/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.util.function.Function;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public final class ToInteger
implements Function<Object, Integer> {
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public ToInteger() {
        this(null);
    }

    public ToInteger(RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
    }

    @Override
    public Integer apply(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException e) {
            if (this.runtimeExceptionSupplier != null) {
                throw this.runtimeExceptionSupplier.get();
            }
            throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Integer", object));
        }
    }
}

