/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function;

import java.util.function.Function;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public final class ToLong
implements Function<Object, Long> {
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public ToLong() {
        this(null);
    }

    public ToLong(RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
    }

    @Override
    public Long apply(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (NumberFormatException e) {
            if (this.runtimeExceptionSupplier != null) {
                throw this.runtimeExceptionSupplier.get();
            }
            throw new UnsupportedOperationException(String.format("Unsupported conversion [%s] to Integer", object));
        }
    }
}

