/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.util;

import java.lang.reflect.Constructor;
import java.util.function.Supplier;

public final class RuntimeExceptionSupplier
implements Supplier<Throwable> {
    private final Class<? extends RuntimeException> clazz;
    private final String message;

    private RuntimeExceptionSupplier(Class<? extends RuntimeException> clazz, String message) {
        this.clazz = clazz;
        this.message = message;
    }

    @Override
    public RuntimeException get() {
        RuntimeException runtimeException;
        try {
            Constructor<? extends RuntimeException> constructor = this.clazz.getConstructor(String.class);
            runtimeException = constructor.newInstance(this.message);
        }
        catch (Throwable t) {
            runtimeException = new RuntimeException(String.format("Exception creating RuntimeException [%s] [%s]", this.clazz.getName(), this.message));
        }
        return runtimeException;
    }

    public static RuntimeExceptionSupplier of(Class<? extends RuntimeException> clazz, String message) {
        return new RuntimeExceptionSupplier(clazz, message);
    }
}

