/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function.conversion;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.antublue.map.accessor.function.exception.ConversionException;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public final class ToBoolean
implements Function<Object, Boolean> {
    private final Set<String> TRUE_SET;
    private final Set<String> FALSE_SET;
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public ToBoolean() {
        this(null);
    }

    public ToBoolean(RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
        this.TRUE_SET = new HashSet<String>();
        this.FALSE_SET = new HashSet<String>();
        String trueString = "y|Y|yes|Yes|YES|true|True|TRUE|on|On|ON";
        String falseString = "n|N|no|No|NO|false|False|FALSE|off|Off|OFF";
        String[] tokens = trueString.split(Pattern.quote("|"));
        Collections.addAll(this.TRUE_SET, tokens);
        tokens = falseString.split(Pattern.quote("|"));
        Collections.addAll(this.FALSE_SET, tokens);
    }

    @Override
    public Boolean apply(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = object.toString();
        if (this.TRUE_SET.contains(string)) {
            return true;
        }
        if (this.FALSE_SET.contains(string)) {
            return false;
        }
        if (this.runtimeExceptionSupplier != null) {
            throw this.runtimeExceptionSupplier.get();
        }
        throw new ConversionException(String.format("Unsupported conversion [%s] to Boolean", string));
    }
}

