/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function.conversion;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.antublue.map.accessor.function.exception.ConversionException;
import org.antublue.map.accessor.shaded.org.joda.time.format.DateTimeFormat;
import org.antublue.map.accessor.shaded.org.joda.time.format.DateTimeFormatter;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public final class ToDate
implements Function<Object, Date> {
    private static final List<DateTimeFormatter> DATE_TIME_FORMATTER_LIST = new ArrayList<DateTimeFormatter>();
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public ToDate() {
        this(null);
    }

    public ToDate(RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
    }

    @Override
    public Date apply(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Long) {
            Long longValue = (Long)object;
            if (longValue < 0L) {
                throw new ConversionException(String.format("Unsupported conversion [%s] to Date", object));
            }
            return new Date(longValue);
        }
        String stringValue = object.toString();
        try {
            Long longValue = Long.parseLong(stringValue);
            if (longValue < 0L) {
                throw new ConversionException(String.format("Unsupported conversion [%s] to Date", object));
            }
            return new Date(longValue);
        }
        catch (NumberFormatException numberFormatException) {
            for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTER_LIST) {
                try {
                    return dateTimeFormatter.parseDateTime(stringValue).toDate();
                }
                catch (Throwable throwable) {
                }
            }
            if (this.runtimeExceptionSupplier != null) {
                throw this.runtimeExceptionSupplier.get();
            }
            throw new ConversionException(String.format("Unsupported conversion [%s] to Date", object));
        }
    }

    static {
        DATE_TIME_FORMATTER_LIST.add(DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssSSSZ"));
        DATE_TIME_FORMATTER_LIST.add(DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssZ"));
        DATE_TIME_FORMATTER_LIST.add(DateTimeFormat.forPattern("yyyyMMdd'T'HHmmssSSSZ"));
        DATE_TIME_FORMATTER_LIST.add(DateTimeFormat.forPattern("yyyyMMdd'T'HHmmssZ"));
    }
}

