/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function.conversion;

import java.util.function.Function;
import org.antublue.map.accessor.function.exception.ConversionException;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public final class ToShort
implements Function<Object, Short> {
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public ToShort() {
        this(null);
    }

    public ToShort(RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
    }

    @Override
    public Short apply(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        try {
            return Short.parseShort(object.toString());
        }
        catch (NumberFormatException e) {
            if (this.runtimeExceptionSupplier != null) {
                throw this.runtimeExceptionSupplier.get();
            }
            throw new ConversionException(String.format("Unsupported conversion [%s] to Integer", object));
        }
    }
}

