/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function.validation;

import java.util.Collection;
import java.util.function.Function;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public class IsInCollection<T>
implements Function<T, T> {
    private final Collection<T> collection;
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public IsInCollection(Collection<T> collection) {
        this(collection, null);
    }

    public IsInCollection(Collection<T> collection, RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this.collection = collection;
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
    }

    @Override
    public T apply(T value) {
        if (this.collection.contains(value)) {
            return value;
        }
        if (this.runtimeExceptionSupplier != null) {
            throw this.runtimeExceptionSupplier.get();
        }
        String messageValue = value == null ? "null" : value.toString();
        throw new IllegalArgumentException(String.format("[%s] is not in Collection", messageValue));
    }
}

