/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.map.accessor.function.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import org.antublue.map.accessor.util.RuntimeExceptionSupplier;

public class IsInRange<T>
implements Function<T, T> {
    private final T minimum;
    private final T maximum;
    private final RuntimeExceptionSupplier runtimeExceptionSupplier;

    public IsInRange(T minimum, T maximum) {
        this(minimum, maximum, null);
    }

    public IsInRange(T minimum, T maximum, RuntimeExceptionSupplier runtimeExceptionSupplier) {
        if (!(minimum instanceof Number)) {
            throw new IllegalArgumentException("minimum is not a Number");
        }
        if (maximum.getClass() != maximum.getClass()) {
            throw new IllegalArgumentException("minimum and maximum types don't match");
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.runtimeExceptionSupplier = runtimeExceptionSupplier;
    }

    @Override
    public T apply(T value) {
        if (value.getClass() != this.minimum.getClass()) {
            throw new IllegalArgumentException("value type doesn't match minimum and maximum types");
        }
        boolean isLessThan = false;
        boolean isGreaterThan = false;
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            isLessThan = byteValue < (Byte)this.minimum;
            isGreaterThan = byteValue > (Byte)this.maximum;
        } else if (value instanceof Short) {
            Short shortValue = (Short)value;
            isLessThan = shortValue < (Short)this.minimum;
            isGreaterThan = shortValue > (Short)this.maximum;
        } else if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            isLessThan = intValue < (Integer)this.minimum;
            isGreaterThan = intValue > (Integer)this.maximum;
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            isLessThan = longValue < (Long)this.minimum;
            isGreaterThan = longValue > (Long)this.maximum;
        } else if (value instanceof Float) {
            Float floatValue = (Float)value;
            isLessThan = floatValue.floatValue() < ((Float)this.minimum).floatValue();
            isGreaterThan = floatValue.floatValue() > ((Float)this.maximum).floatValue();
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            isLessThan = doubleValue < (Double)this.minimum;
            isGreaterThan = doubleValue > (Double)this.maximum;
        } else if (value instanceof BigInteger) {
            BigInteger bigIntegerValue = (BigInteger)value;
            isLessThan = -1 == bigIntegerValue.compareTo((BigInteger)this.minimum);
            isGreaterThan = 1 == bigIntegerValue.compareTo((BigInteger)this.maximum);
        } else if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            isLessThan = -1 == bigDecimalValue.compareTo((BigDecimal)this.minimum);
            boolean bl = isGreaterThan = 1 == bigDecimalValue.compareTo((BigDecimal)this.maximum);
        }
        if (isLessThan) {
            throw new IllegalArgumentException(String.format("[%s] is less than required minimum [%s]", value.toString(), this.minimum.toString()));
        }
        if (isGreaterThan) {
            throw new IllegalArgumentException(String.format("[%s] is greater than required maximum [%s]", value.toString(), this.maximum.toString()));
        }
        return value;
    }
}

