/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.extras;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class Directory
implements AutoCloseable {
    private static final String JAVA_TMPDIR = System.getenv("java.io.tmpdir");
    private final String path;
    private final PathType pathType;
    private final File file;

    private Directory(String path, PathType pathType) throws IOException {
        this.file = pathType == PathType.ABSOLUTE ? new File(path).getAbsoluteFile() : new File(JAVA_TMPDIR + path).getAbsoluteFile();
        Files.createDirectory(this.file.toPath(), new FileAttribute[0]);
        this.path = this.file.getAbsolutePath();
        this.pathType = pathType;
    }

    public File getFile() {
        return this.file;
    }

    public void delete() {
        if (this.path != null) {
            try {
                this.delete(this.path);
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
                System.out.flush();
            }
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public static Directory createRelative(String path) throws IOException {
        Directory.checkNotNullOrEmpty(path, "path is null", "path is empty");
        return Directory.create(path, PathType.RELATIVE);
    }

    public static Directory createAbsolute(String path) throws IOException {
        Directory.checkNotNullOrEmpty(path, "path is null", "path is empty");
        return Directory.create(path, PathType.ABSOLUTE);
    }

    public static Directory create(String path, PathType pathType) throws IOException {
        Directory.checkNotNullOrEmpty(path, "path is null", "path is empty");
        return new Directory(path, pathType);
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Directory directory = (Directory)o;
        return Objects.equals(this.path, directory.path) && this.pathType == directory.pathType && Objects.equals(this.file.getAbsolutePath(), directory.file.getAbsolutePath());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.pathType, this.file});
    }

    private void delete(String path) throws IOException {
        File[] files;
        File f = new File(path);
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File c : files) {
                this.delete(c.getAbsolutePath());
            }
        }
        if (!f.delete()) {
            throw new IOException(String.format("Failed to delete file [%s]", f));
        }
    }

    private static void checkNotNullOrEmpty(String string, String nullMessage, String emptyMessage) {
        if (string == null) {
            throw new IllegalArgumentException(nullMessage);
        }
        if (string.trim().equalsIgnoreCase("")) {
            throw new IllegalArgumentException(emptyMessage);
        }
    }

    public static enum PathType {
        RELATIVE,
        ABSOLUTE;

    }
}

