/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.extras;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LockManager {
    private static LockManager INSTANCE;
    private final ReentrantLock reentrantLock = new ReentrantLock(true);
    private final Map<String, ReentrantReadWriteLock> reentrantReadWriteLockMap = new HashMap<String, ReentrantReadWriteLock>();

    private LockManager() {
    }

    public static synchronized LockManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LockManager();
        }
        return INSTANCE;
    }

    public ReentrantReadWriteLock getLock(String name) {
        ReentrantReadWriteLock reentrantReadWriteLock;
        try {
            this.reentrantLock.lock();
            reentrantReadWriteLock = this.reentrantReadWriteLockMap.get(name);
            if (reentrantReadWriteLock == null) {
                reentrantReadWriteLock = new ReentrantReadWriteLock(true);
                this.reentrantReadWriteLockMap.put(name, reentrantReadWriteLock);
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
        return reentrantReadWriteLock;
    }
}

