/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.extras;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.antublue.test.engine.extras.Executable;

public class Locks {
    private static final LockManager LOCK_MANAGER = new LockManager();

    public static LockReference getReference(Object name) {
        return new LockReference(name);
    }

    public static void execute(Object name, Executable executable) throws Throwable {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (executable == null) {
            throw new IllegalArgumentException("executable is null");
        }
        LockReference lockReference = Locks.getReference(name);
        try {
            lockReference.lock();
            executable.execute();
        }
        finally {
            lockReference.unlock();
        }
    }

    private static class LockManager {
        private final Map<Object, ReferenceCountingReentrantLock> MAP = new ConcurrentHashMap<Object, ReferenceCountingReentrantLock>();

        private LockManager() {
        }

        private void lock(Object name) {
            ReferenceCountingReentrantLock referenceCountingReentrantLock = this.MAP.compute(name, (o, referenceCountingReentrantLock1) -> {
                if (referenceCountingReentrantLock1 == null) {
                    referenceCountingReentrantLock1 = new ReferenceCountingReentrantLock();
                } else {
                    referenceCountingReentrantLock1.incrementCount();
                }
                return referenceCountingReentrantLock1;
            });
            referenceCountingReentrantLock.lock();
        }

        private void unlock(Object name) {
            try {
                ReferenceCountingReentrantLock referenceCountingReentrantLock = this.MAP.compute(name, (o, referenceCountingReentrantLock1) -> {
                    if (referenceCountingReentrantLock1 == null) {
                        throw new IllegalStateException("lock [" + name + "] is not locked");
                    }
                    referenceCountingReentrantLock1.decrementCount();
                    return referenceCountingReentrantLock1;
                });
                referenceCountingReentrantLock.unlock();
                if (referenceCountingReentrantLock.getCount() == 0) {
                    this.MAP.remove(name);
                }
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    public static class LockReference {
        private final Object name;

        private LockReference(Object name) {
            this.name = name;
        }

        public void lock() {
            LOCK_MANAGER.lock(this.name);
        }

        public void unlock() {
            LOCK_MANAGER.unlock(this.name);
        }

        public String toString() {
            return this.name.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockReference that = (LockReference)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }

    static class ReferenceCountingReentrantLock
    extends ReentrantLock {
        private int count = 1;

        public ReferenceCountingReentrantLock() {
            super(true);
        }

        public void incrementCount() {
            ++this.count;
        }

        public void decrementCount() {
            --this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

