/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.extras;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;

public class Signals {
    private static final ReentrantLock LOCK = new ReentrantLock(true);
    private static final Map<Object, LinkedBlockingQueue<Boolean>> MAP = new HashMap<Object, LinkedBlockingQueue<Boolean>>();

    private Signals() {
    }

    public static void signal(Object name) {
        LinkedBlockingQueue<Boolean> linkedBlockingQueue;
        try {
            LOCK.lock();
            linkedBlockingQueue = MAP.get(name);
            if (linkedBlockingQueue == null) {
                linkedBlockingQueue = new LinkedBlockingQueue();
                MAP.put(name, linkedBlockingQueue);
            }
        }
        finally {
            LOCK.unlock();
        }
        try {
            linkedBlockingQueue.put(Boolean.TRUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void await(Object name) {
        LinkedBlockingQueue<Boolean> linkedBlockingQueue;
        try {
            LOCK.lock();
            linkedBlockingQueue = MAP.get(name);
            if (linkedBlockingQueue == null) {
                linkedBlockingQueue = new LinkedBlockingQueue();
                MAP.put(name, linkedBlockingQueue);
            }
        }
        finally {
            LOCK.unlock();
        }
        try {
            linkedBlockingQueue.add(linkedBlockingQueue.take());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

