/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.extras;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.antublue.test.engine.extras.Executable;
import org.antublue.test.engine.extras.Locks;

public class ExecutableSupport {
    private ExecutableSupport() {
    }

    public static Duration execute(Executable executable) throws Throwable {
        if (executable == null) {
            throw new IllegalArgumentException("executable is null");
        }
        long t0 = System.nanoTime();
        executable.execute();
        return Duration.of(System.nanoTime() - t0, ChronoUnit.NANOS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Duration execute(Object key, Executable executable) throws Throwable {
        long t0 = System.nanoTime();
        Locks.LockReference lockReference = Locks.getReference(key);
        try {
            lockReference.lock();
            executable.execute();
            Duration duration = Duration.of(System.nanoTime() - t0, ChronoUnit.NANOS);
            return duration;
        }
        finally {
            lockReference.unlock();
        }
    }
}

