/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.extras;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Signals {
    private static final Map<Object, CountDownLatch> MAP = new ConcurrentHashMap<Object, CountDownLatch>();

    private Signals() {
    }

    public static void signal(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        MAP.compute(key, (k, o) -> {
            if (o == null) {
                o = new CountDownLatch(1);
            }
            return o;
        }).countDown();
    }

    public static void await(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        while (true) {
            try {
                MAP.compute(key, (k, o) -> {
                    if (o == null) {
                        o = new CountDownLatch(1);
                    }
                    return o;
                }).await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void await(Object key, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout [" + timeout + "] is less than 1");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit is null");
        }
        CountDownLatch countDownLatch = MAP.compute(key, (k, o) -> {
            if (o == null) {
                o = new CountDownLatch(1);
            }
            return o;
        });
        countDownLatch.await(timeout, unit);
        if (countDownLatch.getCount() > 0L) {
            throw new TimeoutException("signal [" + key + "] timed out");
        }
    }
}

