/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.extras.throttle;

import org.antublue.test.engine.extras.throttle.Throttle;

public class ExponentialBackoffThrottle
implements Throttle {
    private final long maximumMilliseconds;
    private long throttleMilliseconds;

    public ExponentialBackoffThrottle(long minimumMilliseconds, long maximumMilliseconds) {
        if (minimumMilliseconds < 1L) {
            throw new IllegalArgumentException("minimumMilliseconds [" + minimumMilliseconds + "] is less than 1");
        }
        if (maximumMilliseconds < 1L) {
            throw new IllegalArgumentException("maximumMilliseconds [" + maximumMilliseconds + "] is less than 1");
        }
        if (minimumMilliseconds > maximumMilliseconds) {
            throw new IllegalArgumentException("minimumMilliseconds [" + minimumMilliseconds + "] is greater than maximumMilliseconds [" + maximumMilliseconds + "]");
        }
        this.throttleMilliseconds = minimumMilliseconds;
        this.maximumMilliseconds = maximumMilliseconds;
    }

    @Override
    public void throttle() {
        try {
            Thread.sleep(this.throttleMilliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.throttleMilliseconds *= 2L;
        if (this.throttleMilliseconds > this.maximumMilliseconds) {
            this.throttleMilliseconds = this.maximumMilliseconds;
        }
    }
}

