/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.extras;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.antublue.test.engine.extras.Executable;

public class Locks {
    private static final LockManager LOCK_MANAGER = new LockManager();

    private Locks() {
    }

    public static LockReference getReference(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        return new LockReference(LOCK_MANAGER, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Duration execute(Object key, Executable executable) throws Throwable {
        long t0 = System.nanoTime();
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (executable == null) {
            throw new IllegalArgumentException("executable is null");
        }
        LockReference lockReference = Locks.getReference(key);
        try {
            lockReference.lock();
            executable.execute();
        }
        finally {
            lockReference.unlock();
        }
        return Duration.of(System.nanoTime() - t0, ChronoUnit.NANOS);
    }

    public static class LockReference {
        private final LockManager lockManager;
        private final Object name;

        private LockReference(LockManager lockManager, Object name) {
            this.lockManager = lockManager;
            this.name = name;
        }

        public void lock() {
            this.lockManager.acquire(this.name);
        }

        public void unlock() {
            this.lockManager.release(this.name);
        }

        public String toString() {
            return this.name.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockReference that = (LockReference)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }

    private static class LockManager {
        private final Lock LOCK = new ReentrantLock(true);
        private final Map<Object, LockHolder> MAP = new HashMap<Object, LockHolder>();

        private LockManager() {
        }

        void acquire(Object key) {
            LockHolder lockHolder;
            try {
                this.LOCK.lock();
                lockHolder = this.MAP.compute(key, (k, lh) -> {
                    if (lh == null) {
                        lh = new LockHolder();
                    }
                    return lh;
                });
                lockHolder.increaseLockCount();
            }
            finally {
                this.LOCK.unlock();
            }
            lockHolder.getLock().lock();
        }

        void release(Object key) {
            try {
                this.LOCK.lock();
                LockHolder lockHolder = this.MAP.get(key);
                if (lockHolder == null) {
                    throw new IllegalMonitorStateException(String.format("LockReference [%s] not locked", key));
                }
                if (lockHolder.getLockCount() == 0) {
                    throw new IllegalMonitorStateException(String.format("LockReference [%s] already unlocked", key));
                }
                lockHolder.getLock().unlock();
                lockHolder.decreaseLockCount();
                if (lockHolder.getLockCount() == 0) {
                    this.MAP.remove(key);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
    }

    private static class LockHolder {
        private final ReentrantLock lock = new ReentrantLock(true);
        private int lockCount;

        LockHolder() {
        }

        Lock getLock() {
            return this.lock;
        }

        void increaseLockCount() {
            ++this.lockCount;
        }

        void decreaseLockCount() {
            --this.lockCount;
        }

        int getLockCount() {
            return this.lockCount;
        }
    }
}

