/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api;

import java.util.Objects;
import org.antublue.test.engine.support.api.ParameterImpl;

public interface Parameter {
    public String name();

    public <T> T value();

    public <T> T value(Class<T> var1);

    public static Parameter parameter(String name, Object value) {
        return Parameter.of(name, value);
    }

    public static Parameter of(String name, Object value) {
        Objects.requireNonNull(name);
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        return new ParameterImpl(name.trim(), value);
    }

    public static Parameter of(boolean b) {
        return Parameter.of(String.valueOf(b), b);
    }

    public static Parameter of(byte b) {
        return Parameter.of(String.valueOf(b), b);
    }

    public static Parameter of(char c) {
        return Parameter.of(String.valueOf(c), Character.valueOf(c));
    }

    public static Parameter of(short s) {
        return Parameter.of(String.valueOf(s), s);
    }

    public static Parameter of(int i) {
        return Parameter.of(String.valueOf(i), i);
    }

    public static Parameter of(long l) {
        return Parameter.of(String.valueOf(l), l);
    }

    public static Parameter of(float f) {
        return Parameter.of(String.valueOf(f), Float.valueOf(f));
    }

    public static Parameter of(double d) {
        return Parameter.of(String.valueOf(d), d);
    }

    public static Parameter of(String value) {
        if (value == null) {
            return new ParameterImpl("((null))", null);
        }
        if (value.trim().isEmpty()) {
            return new ParameterImpl("((empty))", value);
        }
        return new ParameterImpl(value, value);
    }
}

