/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.source;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.api.ParameterMap;
import org.antublue.test.engine.com.univocity.parsers.common.processor.RowListProcessor;
import org.antublue.test.engine.com.univocity.parsers.csv.CsvParser;
import org.antublue.test.engine.com.univocity.parsers.csv.CsvParserSettings;

public final class CsvSource {
    private CsvSource() {
    }

    public static Stream<Parameter> of(File file, Charset charset) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            Stream<Parameter> stream = CsvSource.of(inputStream, charset);
            return stream;
        }
    }

    public static Stream<Parameter> of(Reader reader) throws IOException {
        CsvParserSettings parserSettings = new CsvParserSettings();
        parserSettings.setLineSeparatorDetectionEnabled(true);
        RowListProcessor rowListProcessor = new RowListProcessor();
        parserSettings.setProcessor(rowListProcessor);
        parserSettings.setHeaderExtractionEnabled(true);
        CsvParser parser = new CsvParser(parserSettings);
        parser.parse(reader);
        return CsvSource.process(rowListProcessor);
    }

    public static Stream<Parameter> of(InputStream inputStream, Charset charset) throws IOException {
        CsvParserSettings parserSettings = new CsvParserSettings();
        parserSettings.setLineSeparatorDetectionEnabled(true);
        RowListProcessor rowListProcessor = new RowListProcessor();
        parserSettings.setProcessor(rowListProcessor);
        parserSettings.setHeaderExtractionEnabled(true);
        CsvParser parser = new CsvParser(parserSettings);
        parser.parse(inputStream, charset);
        return CsvSource.process(rowListProcessor);
    }

    private static Stream<Parameter> process(RowListProcessor rowListProcessor) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        String[] headers = rowListProcessor.getHeaders();
        List<String[]> rows = rowListProcessor.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            ParameterMap parameterMap = new ParameterMap();
            String[] row = rows.get(i);
            for (int j = 0; j < row.length; ++j) {
                String header = null;
                try {
                    header = headers[j];
                    if (header.trim().isEmpty()) {
                        header = "column[" + (j + 1) + "]";
                    }
                }
                catch (Throwable t) {
                    header = "column[" + (j + 1) + "]";
                }
                parameterMap.put(header, (Object)row[j]);
            }
            list.add(Parameter.of("row[" + (i + 1) + "]", parameterMap));
        }
        return list.stream();
    }
}

