/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.support.TestClassConfigurationException;
import org.antublue.test.engine.support.TestEngineConfiguration;
import org.antublue.test.engine.support.TestEngineException;
import org.antublue.test.engine.support.TestEngineUtils;
import org.antublue.test.engine.support.descriptor.TestEngineClassTestDescriptor;
import org.antublue.test.engine.support.descriptor.TestEngineParameterTestDescriptor;
import org.antublue.test.engine.support.descriptor.TestEngineTestMethodTestDescriptor;
import org.antublue.test.engine.support.logger.Logger;
import org.antublue.test.engine.support.logger.LoggerFactory;
import org.antublue.test.engine.support.predicate.TestClassPredicate;
import org.antublue.test.engine.support.predicate.TestClassTagPredicate;
import org.antublue.test.engine.support.predicate.TestMethodPredicate;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class TestEngineDiscoverySelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineDiscoverySelectorResolver.class);
    private final TestClassPredicate includeTestClassPredicate;
    private final TestClassPredicate excludeTestClassPredicate;
    private final TestMethodPredicate includeTestMethodPredicate;
    private final TestMethodPredicate excludeTestMethodPredicate;
    private final TestClassTagPredicate includeTestClassTagPredicate;
    private final TestClassTagPredicate excludeTestClassTagPredicate;
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !TestEngineUtils.getTestMethods(clazz).isEmpty();
    };
    private static final Predicate<Method> IS_TEST_METHOD = method -> TestEngineUtils.getTestMethods(method.getDeclaringClass()).contains(method);

    public TestEngineDiscoverySelectorResolver() {
        String includeTestClassPredicateRegex = TestEngineConfiguration.getConfigurationValue("antublue.test.engine.test.class.include");
        LOGGER.trace(String.format("antublue.test.engine.test.class.include [%s]", includeTestClassPredicateRegex));
        this.includeTestClassPredicate = includeTestClassPredicateRegex != null ? TestClassPredicate.of(includeTestClassPredicateRegex) : null;
        String excludeTestClassPredicateRegex = TestEngineConfiguration.getConfigurationValue("antublue.test.engine.test.class.exclude");
        LOGGER.trace(String.format("antublue.test.engine.test.class.exclude [%s]", excludeTestClassPredicateRegex));
        this.excludeTestClassPredicate = excludeTestClassPredicateRegex != null ? TestClassPredicate.of(excludeTestClassPredicateRegex) : null;
        String includeTestMethodPredicateRegex = TestEngineConfiguration.getConfigurationValue("antublue.test.engine.test.method.include");
        LOGGER.trace(String.format("antublue.test.engine.test.method.include [%s]", includeTestMethodPredicateRegex));
        this.includeTestMethodPredicate = includeTestMethodPredicateRegex != null ? TestMethodPredicate.of(includeTestMethodPredicateRegex) : null;
        String excludeTestMethodPredicateRegex = TestEngineConfiguration.getConfigurationValue("antublue.test.engine.test.method.exclude");
        LOGGER.trace(String.format("antublue.test.engine.test.method.exclude [%s]", excludeTestMethodPredicateRegex));
        this.excludeTestMethodPredicate = excludeTestMethodPredicateRegex != null ? TestMethodPredicate.of(excludeTestMethodPredicateRegex) : null;
        String includeTestClassTagsRegex = TestEngineConfiguration.getConfigurationValue("antublue.test.engine.test.class.tag.include");
        LOGGER.trace(String.format("antublue.test.engine.test.class.tag.include [%s]", includeTestClassTagsRegex));
        this.includeTestClassTagPredicate = includeTestClassTagsRegex != null ? TestClassTagPredicate.of(includeTestClassTagsRegex) : null;
        String excludeTestClassTagsRegex = TestEngineConfiguration.getConfigurationValue("antublue.test.engine.test.class.tag.exclude");
        LOGGER.trace(String.format("antublue.test.engine.test.class.tag.exclude [%s]", excludeTestClassTagsRegex));
        this.excludeTestClassTagPredicate = excludeTestClassTagsRegex != null ? TestClassTagPredicate.of(excludeTestClassTagsRegex) : null;
    }

    public void resolveSelectors(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        ArrayList<Method> methods;
        HashMap workingTestClassToMethodMap;
        LOGGER.trace("resolveSelectors()");
        TreeMap testClassToMethodMap = new TreeMap(Comparator.comparing(Class::getName));
        this.resolveClasspathRoot(engineDiscoveryRequest, testClassToMethodMap);
        this.resolvePackageSelector(engineDiscoveryRequest, testClassToMethodMap);
        this.resolveClassSelector(engineDiscoveryRequest, testClassToMethodMap);
        this.resolveMethodSelector(engineDiscoveryRequest, testClassToMethodMap);
        if (this.includeTestClassPredicate != null) {
            workingTestClassToMethodMap = new HashMap(testClassToMethodMap);
            for (Class clazz : workingTestClassToMethodMap.keySet()) {
                if (this.includeTestClassPredicate.test(clazz)) continue;
                testClassToMethodMap.remove(clazz);
            }
        }
        if (this.excludeTestClassPredicate != null) {
            workingTestClassToMethodMap = new HashMap(testClassToMethodMap);
            for (Class clazz : workingTestClassToMethodMap.keySet()) {
                if (!this.excludeTestClassPredicate.test(clazz)) continue;
                testClassToMethodMap.remove(clazz);
            }
        }
        if (this.includeTestMethodPredicate != null) {
            workingTestClassToMethodMap = new HashMap(testClassToMethodMap);
            for (Class clazz : workingTestClassToMethodMap.keySet()) {
                methods = new ArrayList<Method>((Collection)testClassToMethodMap.get(clazz));
                methods.removeIf(method -> !this.includeTestMethodPredicate.test((Method)method));
                if (methods.isEmpty()) {
                    testClassToMethodMap.remove(clazz);
                    continue;
                }
                testClassToMethodMap.put(clazz, methods);
            }
        }
        if (this.excludeTestMethodPredicate != null) {
            workingTestClassToMethodMap = new HashMap(testClassToMethodMap);
            for (Class clazz : workingTestClassToMethodMap.keySet()) {
                methods = new ArrayList((Collection)workingTestClassToMethodMap.get(clazz));
                methods.removeIf(this.excludeTestMethodPredicate);
                if (methods.isEmpty()) {
                    testClassToMethodMap.remove(clazz);
                    continue;
                }
                testClassToMethodMap.put(clazz, methods);
            }
        }
        if (this.includeTestClassTagPredicate != null) {
            workingTestClassToMethodMap = new HashMap(testClassToMethodMap);
            for (Class clazz : workingTestClassToMethodMap.keySet()) {
                if (this.includeTestClassTagPredicate.test(clazz)) continue;
                testClassToMethodMap.remove(clazz);
            }
        }
        if (this.excludeTestClassTagPredicate != null) {
            workingTestClassToMethodMap = new HashMap(testClassToMethodMap);
            for (Class clazz : workingTestClassToMethodMap.keySet()) {
                if (!this.excludeTestClassTagPredicate.test(clazz)) continue;
                testClassToMethodMap.remove(clazz);
            }
        }
        this.processSelectors(engineDescriptor, testClassToMethodMap);
    }

    private void resolveClasspathRoot(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Collection<Method>> testClassToMethodMap) {
        LOGGER.trace("resolveClasspathRoot()");
        List discoverySelectorList = engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class);
        LOGGER.trace(String.format("discoverySelectorList size [%d]", discoverySelectorList.size()));
        for (DiscoverySelector discoverySelector : discoverySelectorList) {
            URI uri = ((ClasspathRootSelector)discoverySelector).getClasspathRoot();
            LOGGER.trace(String.format("uri [%s]", uri));
            List classList = ReflectionSupport.findAllClassesInClasspathRoot((URI)uri, IS_TEST_CLASS, name -> true);
            for (Class clazz : classList) {
                LOGGER.trace(String.format("  class [%s]", clazz.getName()));
                testClassToMethodMap.putIfAbsent(clazz, TestEngineUtils.getTestMethods(clazz));
            }
        }
    }

    private void resolvePackageSelector(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Collection<Method>> testClassToMethodMap) {
        LOGGER.trace("resolvePackageSelector()");
        List discoverySelectorList = engineDiscoveryRequest.getSelectorsByType(PackageSelector.class);
        LOGGER.trace("discoverySelectorList size [%d]", (Object)discoverySelectorList.size());
        for (DiscoverySelector discoverySelector : discoverySelectorList) {
            String packageName = ((PackageSelector)discoverySelector).getPackageName();
            List classList = ReflectionSupport.findAllClassesInPackage((String)packageName, IS_TEST_CLASS, name -> true);
            for (Class clazz : classList) {
                LOGGER.trace(String.format("  test class [%s]", clazz.getName()));
                testClassToMethodMap.putIfAbsent(clazz, TestEngineUtils.getTestMethods(clazz));
            }
        }
    }

    private void resolveClassSelector(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Collection<Method>> testClassToMethodMap) {
        LOGGER.trace("resolveClassSelector()");
        List discoverySelectorList = engineDiscoveryRequest.getSelectorsByType(ClassSelector.class);
        LOGGER.trace("discoverySelectorList size [%d]", (Object)discoverySelectorList.size());
        for (DiscoverySelector discoverySelector : discoverySelectorList) {
            Class clazz = ((ClassSelector)discoverySelector).getJavaClass();
            if (IS_TEST_CLASS.test(clazz)) {
                LOGGER.trace(String.format("  test class [%s]", clazz.getName()));
                testClassToMethodMap.putIfAbsent(clazz, TestEngineUtils.getTestMethods(clazz));
                continue;
            }
            LOGGER.trace(String.format("  skipping [%s]", clazz.getName()));
        }
    }

    private void resolveMethodSelector(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Collection<Method>> testClassToMethodMap) {
        LOGGER.trace("resolveMethodSelector()");
        List discoverySelectorList = engineDiscoveryRequest.getSelectorsByType(MethodSelector.class);
        LOGGER.trace(String.format("discoverySelectorList size [%d]", discoverySelectorList.size()));
        for (DiscoverySelector discoverySelector : discoverySelectorList) {
            Method method = ((MethodSelector)discoverySelector).getJavaMethod();
            Class<?> clazz = method.getDeclaringClass();
            if (!IS_TEST_METHOD.test(method)) continue;
            LOGGER.trace(String.format("  test class [%s] @TestEngine.Test method [%s]", clazz.getName(), method.getName()));
            Collection methods = testClassToMethodMap.computeIfAbsent(clazz, k -> new ArrayList());
            methods.add(method);
        }
    }

    private void processSelectors(EngineDescriptor engineDescriptor, Map<Class<?>, Collection<Method>> testClassToMethodMap) {
        LOGGER.trace("processSelectors()");
        UniqueId uniqueId = engineDescriptor.getUniqueId();
        try {
            for (Class<?> testClass : testClassToMethodMap.keySet()) {
                Collection testParameters;
                LOGGER.trace(String.format("test class [%s]", testClass.getName()));
                if (TestEngineUtils.isBaseClass(testClass)) {
                    LOGGER.trace(String.format("test class [%s] is a base class not meant for execution", testClass.getName()));
                    continue;
                }
                if (TestEngineUtils.isDisabled(testClass)) {
                    LOGGER.trace(String.format("test class [%s] is disabled", testClass.getName()));
                    continue;
                }
                LOGGER.trace(String.format("processing test class [%s]", testClass.getName()));
                Collection<Method> parameterSupplierMethods = TestEngineUtils.getParameterSupplierMethods(testClass);
                LOGGER.trace(String.format("test class [%s] parameter supplier method count [%d]", testClass.getName(), parameterSupplierMethods.size()));
                if (parameterSupplierMethods.isEmpty()) {
                    throw new TestClassConfigurationException(String.format("Test class [%s] must declare a @TestEngine.ParameterSupplier method", testClass.getName()));
                }
                if (parameterSupplierMethods.size() > 1) {
                    throw new TestClassConfigurationException(String.format("Test class [%s] declares more than one @TestEngine.ParameterSupplier method", testClass.getName()));
                }
                try {
                    Stream testParameterStream = (Stream)parameterSupplierMethods.stream().findFirst().get().invoke(null, (Object[])null);
                    if (testParameterStream == null) {
                        throw new TestClassConfigurationException(String.format("Test class [%s] @TestEngine.ParameterSupplier Stream is null", testClass.getName()));
                    }
                    testParameters = testParameterStream.collect(Collectors.toList());
                }
                catch (ClassCastException e) {
                    throw new TestClassConfigurationException(String.format("Test class [%s] @TestEngine.ParameterSupplier method must return a Stream<Parameter>", testClass.getName()), e);
                }
                LOGGER.trace("test class parameter count [%d]", (Object)testParameters.size());
                if (testParameters.isEmpty()) {
                    throw new TestClassConfigurationException(String.format("Test class [%s] @TestEngine.ParameterSupplier Stream is empty", testClass.getName()));
                }
                Collection<Method> parameterSetterMethods = TestEngineUtils.getParameterSetterMethods(testClass);
                LOGGER.trace(String.format("test class [%s] parameter setter method count [%d]", testClass.getName(), parameterSetterMethods.size()));
                if (parameterSetterMethods.isEmpty()) {
                    throw new TestClassConfigurationException(String.format("Test class [%s] must declare a @TestEngine.ParameterSetter method", testClass.getName()));
                }
                if (parameterSetterMethods.size() > 1) {
                    throw new TestClassConfigurationException(String.format("Test class [%s] declares more than one @TestEngine.ParameterSetter method", testClass.getName()));
                }
                TestEngineClassTestDescriptor testClassTestDescriptor = new TestEngineClassTestDescriptor(uniqueId.append("/", testClass.getName()), testClass.getName(), testClass);
                ArrayList testParameterList = new ArrayList(testParameters);
                for (Parameter testParameter : testParameterList) {
                    String testParameterName = testParameter.name();
                    String testParameterUniqueName = testParameter + "/" + UUID.randomUUID();
                    TestEngineParameterTestDescriptor testEngineParameterTestDescriptor = new TestEngineParameterTestDescriptor(uniqueId.append("/", testClass.getName() + "/" + testParameterUniqueName), testParameterName, testClass, testParameter);
                    for (Method testMethod : testClassToMethodMap.get(testClass)) {
                        if (TestEngineUtils.isDisabled(testMethod)) {
                            LOGGER.trace(String.format("test class [%s] test method [%s] is disabled", testClass.getName(), testMethod.getName()));
                            continue;
                        }
                        String testMethodUniqueName = testParameterName + "/" + UUID.randomUUID();
                        TestEngineTestMethodTestDescriptor testEngineTestMethodTestDescriptor = new TestEngineTestMethodTestDescriptor(uniqueId.append("/", testClass.getName() + "/" + testParameterUniqueName + "/" + testMethodUniqueName), testMethod.getName(), testClass, testParameter, testMethod);
                        testEngineParameterTestDescriptor.addChild((TestDescriptor)testEngineTestMethodTestDescriptor);
                    }
                    if (testEngineParameterTestDescriptor.getChildren().size() <= 0) continue;
                    testClassTestDescriptor.addChild((TestDescriptor)testEngineParameterTestDescriptor);
                }
                if (testClassTestDescriptor.getChildren().size() <= 0) continue;
                engineDescriptor.addChild((TestDescriptor)testClassTestDescriptor);
            }
        }
        catch (Throwable t) {
            throw new TestEngineException("Exception in TestEngine", t);
        }
    }
}

