/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.support.logger;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.antublue.test.engine.support.logger.Level;
import org.antublue.test.engine.support.logger.Logger;

public final class LoggerFactory {
    private static final Map<String, Level> LEVEL_MAP = new HashMap<String, Level>();
    private static final Map<String, Logger> LOGGER_MAP = new HashMap<String, Logger>();
    private static final Level LEVEL;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Logger logger;
        Map<String, Logger> map = LOGGER_MAP;
        synchronized (map) {
            logger = LOGGER_MAP.get(name);
            if (logger == null) {
                logger = new Logger(name, LEVEL);
                LOGGER_MAP.put(name, logger);
            }
        }
        return logger;
    }

    private static Level getLevel() {
        String propertyName = "antublue.test.engine.log.level";
        String propertyValue = System.getProperty(propertyName);
        String environmentVariableValue = System.getenv(propertyName.toUpperCase(Locale.ENGLISH).replace('.', '_'));
        if (propertyValue != null && !propertyValue.trim().isEmpty()) {
            return LEVEL_MAP.getOrDefault(propertyValue.trim().toUpperCase(Locale.ENGLISH), Level.INFO);
        }
        if (environmentVariableValue != null && !environmentVariableValue.trim().isEmpty()) {
            return LEVEL_MAP.getOrDefault(environmentVariableValue.toUpperCase(Locale.ENGLISH), Level.INFO);
        }
        return Level.INFO;
    }

    static {
        LEVEL_MAP.put("ERROR", Level.ERROR);
        LEVEL_MAP.put("WARN", Level.WARN);
        LEVEL_MAP.put("INFO", Level.INFO);
        LEVEL_MAP.put("DEBUG", Level.DEBUG);
        LEVEL_MAP.put("TRACE", Level.TRACE);
        LEVEL_MAP.put("ALL", Level.ALL);
        LEVEL = LoggerFactory.getLevel();
    }
}

