package org.antublue.test.engine.internal;

import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class TestEngineTestExecutionListener implements TestExecutionListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineTestExecutionListener.class);

    private final boolean log;

    public TestEngineTestExecutionListener() {
        log = TestEngineConfigurationParameters.getInstance()
                .get("antublue.test.engine.log.test.execution")
                .map(s -> {
                    if (s.equalsIgnoreCase("true")) {
                        return true;
                    } else {
                        return false;
                    }
                }
                )
                .orElse(true);
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        if (log) {
            LOGGER.info("testPlanExecutionStarted(TestPlan)");
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (log) {
            LOGGER.info("testPlanExecutionFinished(TestPlan)");
        }
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        if (log) {
            LOGGER.info("dynamicTestRegistered [%s]", testIdentifier.getUniqueId());
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (log) {
            LOGGER.info("executionSkipped [%s]", testIdentifier.getUniqueId());
        }
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (log) {
            LOGGER.info("executionStarted [%s]", testIdentifier.getUniqueId());
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (log) {
            LOGGER.info("executionFinished [%s]", testIdentifier.getUniqueId());
        }
    }

    public  void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        if (log) {
            LOGGER.info("reportingEntryPublished [%s]", testIdentifier.getUniqueId());
        }
    }
}
