/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.antublue.test.engine.internal.TestEngineConfigurationParameters;
import org.antublue.test.engine.internal.TestEngineDiscoveryRequestProcessor;
import org.antublue.test.engine.internal.TestEngineEngineDiscoveryRequest;
import org.antublue.test.engine.internal.TestEngineExecutor;
import org.antublue.test.engine.internal.TestEngineInformation;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.TestEngineSummaryEngineExecutionListener;
import org.antublue.test.engine.internal.descriptor.TestEngineClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestEngineParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.HumanReadableTime;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class TestEngine
implements org.junit.platform.engine.TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngine.class);
    public static final String ENGINE_ID = "antublue-test-engine";
    public static final String GROUP_ID = "org.antublue";
    public static final String ARTIFACT_ID = "test-engine";
    public static final String VERSION = TestEngineInformation.getVersion();

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        TestEngineEngineDiscoveryRequest testEngineDiscoveryRequest = new TestEngineEngineDiscoveryRequest(engineDiscoveryRequest, TestEngineConfigurationParameters.getInstance());
        EngineDescriptor engineDescriptor = new EngineDescriptor(UniqueId.forEngine((String)this.getId()), this.getId());
        new TestEngineDiscoveryRequestProcessor().processDiscoveryRequest(testEngineDiscoveryRequest, engineDescriptor);
        if (LOGGER.isTraceEnabled()) {
            TestEngine.walk(engineDescriptor);
        }
        return engineDescriptor;
    }

    public void execute(ExecutionRequest executionRequest) {
        new TestEngineExecutor().execute(executionRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long startTimeMilliseconds = System.currentTimeMillis();
        PrintStream printStream = null;
        boolean failed = false;
        try {
            printStream = System.out;
            String banner = "AntuBLUE Test Engine " + VERSION;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < banner.length(); ++i) {
                stringBuilder.append("-");
            }
            String separator = stringBuilder.toString();
            LOGGER.info(separator);
            LOGGER.info(banner);
            LOGGER.info(separator);
            LOGGER.info("Scanning all classpath jars for tests...");
            TreeSet<Path> classPathRoots = new TreeSet<Path>(Comparator.comparing(o -> o.toAbsolutePath().toFile().getAbsolutePath()));
            File file = new File(TestEngine.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            classPathRoots.add(file.getAbsoluteFile().toPath());
            String classPath = System.getProperty("java.class.path");
            String[] jars = classPath.split(File.pathSeparator);
            for (String jar : jars) {
                classPathRoots.add(new File(jar).getAbsoluteFile().toPath());
            }
            for (Path path : classPathRoots) {
                LOGGER.trace("jar [{}]", (Object)path.toAbsolutePath());
            }
            TestEngine testEngine = new TestEngine();
            LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(classPathRoots)).filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{".*"})}).configurationParameters(new HashMap()).build();
            TestDescriptor testDescriptor = testEngine.discover((EngineDiscoveryRequest)launcherDiscoveryRequest, UniqueId.root((String)"/", (String)"/"));
            if (testDescriptor.getChildren().size() == 0) {
                long endTimeMilliseconds = System.currentTimeMillis();
                LOGGER.info("");
                LOGGER.info(separator);
                LOGGER.info("ERROR / NO TESTS FOUND");
                LOGGER.info(separator);
                LOGGER.info("Total Time  : " + HumanReadableTime.toHumanReadable(endTimeMilliseconds - startTimeMilliseconds, false));
                LOGGER.info("Finished At : " + HumanReadableTime.now());
                LOGGER.info(separator);
                System.exit(-2);
            }
            TestPlan testPlan = TestEngineReflectionUtils.createTestPlan(testDescriptor, TestEngineConfigurationParameters.getInstance());
            TestEngineSummaryEngineExecutionListener summaryEngineExecutionListener = new TestEngineSummaryEngineExecutionListener(testPlan);
            testEngine.execute(ExecutionRequest.create((TestDescriptor)testDescriptor, (EngineExecutionListener)summaryEngineExecutionListener, (ConfigurationParameters)launcherDiscoveryRequest.getConfigurationParameters()));
            long endTimeMilliseconds = System.currentTimeMillis();
            TestExecutionSummary testExecutionSummary = summaryEngineExecutionListener.getSummary();
            banner = "AntuBLUE Test Engine " + VERSION + " Summary";
            stringBuilder.setLength(0);
            for (int i = 0; i < banner.length(); ++i) {
                stringBuilder.append("-");
            }
            separator = stringBuilder.toString();
            LOGGER.info(separator);
            LOGGER.info(banner);
            LOGGER.info(separator);
            LOGGER.info("");
            LOGGER.info("TESTS : " + (testExecutionSummary.getTestsFoundCount() + testExecutionSummary.getContainersFailedCount()) + ", PASSED : " + (testExecutionSummary.getTestsSucceededCount() - testExecutionSummary.getContainersFailedCount()) + ", FAILED : " + (testExecutionSummary.getTestsFailedCount() + testExecutionSummary.getContainersFailedCount()) + ", SKIPPED : " + testExecutionSummary.getTestsSkippedCount());
            LOGGER.info("");
            LOGGER.info(separator);
            boolean bl = failed = testExecutionSummary.getTestsFailedCount() + testExecutionSummary.getContainersFailedCount() > 0L;
            if (failed) {
                LOGGER.info("FAILED");
            } else {
                LOGGER.info("PASSED");
            }
            LOGGER.info(separator);
            LOGGER.info("Total Time  : " + HumanReadableTime.toHumanReadable(endTimeMilliseconds - startTimeMilliseconds, false));
            LOGGER.info("Finished At : " + HumanReadableTime.now());
            LOGGER.info(separator);
        }
        catch (Throwable t) {
            failed = true;
            LOGGER.error("Internal Error occurred.");
            t.printStackTrace();
        }
        finally {
            if (printStream != null) {
                try {
                    printStream.close();
                }
                catch (Throwable banner) {}
            }
            if (failed) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
    }

    private static void walk(EngineDescriptor engineDescriptor) {
        LOGGER.trace("EngineDescriptor - > " + engineDescriptor.getUniqueId());
        Set testDescriptors = engineDescriptor.getChildren();
        for (TestDescriptor testDescriptor : testDescriptors) {
            TestEngine.walk(testDescriptor, 2);
        }
    }

    private static void walk(TestDescriptor parentTestDescriptor, int indent) {
        if (parentTestDescriptor instanceof TestEngineClassTestDescriptor) {
            LOGGER.trace(TestEngine.pad(indent) + "TestEngineClassTestDescriptor - > " + parentTestDescriptor.getUniqueId());
            Set testDescriptors = ((TestEngineClassTestDescriptor)parentTestDescriptor).getChildren();
            for (TestDescriptor childTestDescriptor : testDescriptors) {
                TestEngine.walk(childTestDescriptor, indent + 2);
            }
        } else if (parentTestDescriptor instanceof TestEngineParameterTestDescriptor) {
            LOGGER.trace(TestEngine.pad(indent) + "TestEngineParameterTestDescriptor - > " + parentTestDescriptor.getUniqueId());
            Set testDescriptors = ((TestEngineParameterTestDescriptor)parentTestDescriptor).getChildren();
            for (TestDescriptor childTestDescriptor : testDescriptors) {
                TestEngine.walk(childTestDescriptor, indent + 2);
            }
        } else {
            LOGGER.trace(TestEngine.pad(indent) + "TestEngineTestMethodTestDescriptor - > " + parentTestDescriptor.getUniqueId());
        }
    }

    private static String pad(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

