/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

public class ParameterMap
extends LinkedHashMap<String, Object> {
    @Override
    public boolean containsKey(Object key) {
        ParameterMap.validateKey(key);
        return super.containsKey(key);
    }

    @Override
    public ParameterMap put(String key, Object object) {
        ParameterMap.validateKey(key);
        super.put(key, object);
        return this;
    }

    @Override
    public void putAll(Map map) {
        Objects.requireNonNull(map);
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String key = ParameterMap.validateKey(entry.getKey());
            this.put(key, entry.getValue());
        }
    }

    @Override
    public Object putIfAbsent(String key, Object object) {
        ParameterMap.validateKey(key);
        return this.putIfAbsent(key, object);
    }

    @Override
    public Object merge(String key, Object value, BiFunction<Object, Object, Object> remappingFunction) {
        throw new UnsupportedOperationException("Merge is not supported");
    }

    public <T> T get(String key) {
        Objects.requireNonNull(key);
        if (key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key is empty");
        }
        return (T)super.get(key);
    }

    public <T> T get(String key, Class<T> clazz) {
        T value = this.get(key);
        if (value == null) {
            return null;
        }
        return clazz.cast(value);
    }

    private static String validateKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Illegal key type [" + key.getClass().getName() + "] String is required");
        }
        String stringKey = (String)key;
        if (stringKey.trim().isEmpty()) {
            throw new IllegalArgumentException("Key is empty");
        }
        return stringKey;
    }
}

