/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.TestPlan;

public final class TestEngineReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineReflectionUtils.class);
    private static final Map<Class<?>, Collection<Method>> parameterSupplierMethodCache = new HashMap();
    private static final Map<Class<?>, Collection<Field>> parameterFieldCache = new HashMap();
    private static final Map<Class<?>, Collection<Method>> parameterMethodCache = new HashMap();
    private static final Map<Class<?>, Collection<Method>> beforeClassMethodCache = new HashMap();
    private static final Map<Class<?>, Collection<Method>> beforeAllMethodCache = new HashMap();
    private static final Map<Class<?>, Collection<Method>> beforeEachMethodCache = new HashMap();
    private static final Map<Class<?>, Collection<Method>> testMethodCache = new HashMap();
    private static final Map<Class<?>, Collection<Method>> afterEachMethodCache = new HashMap();
    private static final Map<Class<?>, Collection<Method>> afterAllMethodCache = new HashMap();
    private static final Map<Class<?>, Collection<Method>> afterClassMethodCache = new HashMap();
    private static final Map<Class<?>, String> classDisplayNameCache = new HashMap();
    private static final Map<Method, String> methodDisplayNameCache = new HashMap<Method, String>();

    private TestEngineReflectionUtils() {
    }

    private static List<Method> getMethods(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("getMethods(%s, %s, %s, %s", new Object[]{clazz.getName(), annotation.getName(), scope, returnType.getName()}));
        if (parameterTypes != null) {
            for (Class<?> parameterTypeClass : parameterTypes) {
                stringBuilder.append(", ").append(parameterTypeClass.getName());
            }
        }
        stringBuilder.append(")");
        LOGGER.trace(stringBuilder.toString());
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        TestEngineReflectionUtils.resolveMethods(clazz, annotation, scope, returnType, parameterTypes, methodMap);
        ArrayList<Method> methodList = new ArrayList<Method>(methodMap.values());
        methodList.sort(Comparator.comparing(Method::getName));
        return methodList;
    }

    private static void resolveMethods(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?>[] parameterTypes, Map<String, Method> methodMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("resolveMethods(%s, %s, %s, %s", new Object[]{clazz.getName(), annotation.getName(), scope, returnType.getName()}));
        if (parameterTypes != null) {
            for (Class<?> parameterTypeClass : parameterTypes) {
                stringBuilder.append(", ").append(parameterTypeClass.getName());
            }
        }
        stringBuilder.append(")");
        LOGGER.trace(stringBuilder.toString());
        Stream.of(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotation)).filter(method -> {
            int modifiers = method.getModifiers();
            return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
        }).filter(method -> {
            int modifiers = method.getModifiers();
            if (scope == Scope.STATIC) {
                return Modifier.isStatic(modifiers);
            }
            return !Modifier.isStatic(modifiers);
        }).filter(method -> {
            if (parameterTypes == null) {
                return method.getParameterTypes().length == 0;
            }
            if (parameterTypes.length != method.getParameterCount()) {
                return false;
            }
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (methodParameterTypes[i].isAssignableFrom(parameterTypes[i])) continue;
                return false;
            }
            return true;
        }).filter(method -> {
            if (returnType == Void.class) {
                return method.getReturnType().getName().equals("void");
            }
            return method.getReturnType().equals(returnType);
        }).forEach(method -> {
            if (methodMap.putIfAbsent(method.getName(), (Method)method) == null) {
                method.setAccessible(true);
            }
        });
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            TestEngineReflectionUtils.resolveMethods(declaringClass, annotation, scope, returnType, parameterTypes, methodMap);
        }
    }

    private static Collection<Field> getFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType) {
        LOGGER.trace("getFields(%s, %s, %s)", clazz.getName(), annotation.getName(), fieldType.getName());
        LinkedHashSet<Field> fieldSet = new LinkedHashSet<Field>();
        TestEngineReflectionUtils.resolveFields(clazz, annotation, fieldType, fieldSet);
        return fieldSet;
    }

    private static void resolveFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType, Set<Field> fieldSet) {
        Field[] fields;
        LOGGER.trace("resolveMethods(%s, %s, %s)", clazz.getName(), annotation.getName(), fieldType);
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || !field.isAnnotationPresent(TestEngine.Parameter.class) || field.getType() != fieldType) continue;
            field.setAccessible(true);
            fieldSet.add(field);
        }
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            TestEngineReflectionUtils.resolveFields(declaringClass, annotation, fieldType, fieldSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Field> getParameterFields(Class<?> clazz) {
        Map<Class<?>, Collection<Field>> map = parameterFieldCache;
        synchronized (map) {
            LOGGER.trace(String.format("getParameterFields(%s)", clazz.getName()));
            if (parameterFieldCache.containsKey(clazz)) {
                return parameterFieldCache.get(clazz);
            }
            Collection<Field> parameterFields = TestEngineReflectionUtils.getFields(clazz, TestEngine.Parameter.class, Parameter.class);
            parameterFieldCache.put(clazz, parameterFields);
            return parameterFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getBeforeClassMethods(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = beforeClassMethodCache;
        synchronized (map) {
            LOGGER.trace(String.format("getBeforeClassMethods(%s)", clazz.getName()));
            if (beforeClassMethodCache.containsKey(clazz)) {
                return beforeClassMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.BeforeClass.class, Scope.STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            beforeClassMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getParameterSupplierMethod(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = parameterSupplierMethodCache;
        synchronized (map) {
            LOGGER.trace(String.format("getParameterSupplierMethod(%s)", clazz.getName()));
            if (parameterSupplierMethodCache.containsKey(clazz)) {
                return parameterSupplierMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.ParameterSupplier.class, Scope.STATIC, Stream.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            parameterSupplierMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getParameterMethods(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = parameterMethodCache;
        synchronized (map) {
            LOGGER.trace(String.format("getParameterMethods(%s)", clazz.getName()));
            if (parameterMethodCache.containsKey(clazz)) {
                return parameterMethodCache.get(clazz);
            }
            List<Method> methodList1 = TestEngineReflectionUtils.getMethods(clazz, TestEngine.ParameterSetter.class, Scope.NON_STATIC, Void.class, Parameter.class);
            List<Method> methodList2 = TestEngineReflectionUtils.getMethods(clazz, TestEngine.Parameter.class, Scope.NON_STATIC, Void.class, Parameter.class);
            ArrayList<Method> methodList = new ArrayList<Method>();
            methodList.addAll(methodList1);
            methodList.addAll(methodList2);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            parameterMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getBeforeAllMethods(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = beforeAllMethodCache;
        synchronized (map) {
            if (beforeAllMethodCache.containsKey(clazz)) {
                return beforeAllMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.BeforeAll.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            beforeAllMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getBeforeEachMethods(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = beforeEachMethodCache;
        synchronized (map) {
            if (beforeEachMethodCache.containsKey(clazz)) {
                return beforeEachMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.BeforeEach.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            beforeEachMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getTestMethods(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = testMethodCache;
        synchronized (map) {
            LOGGER.trace(String.format("getTestMethods(%s)", clazz.getName()));
            if (testMethodCache.containsKey(clazz)) {
                return testMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.Test.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            testMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getAfterEachMethods(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = afterEachMethodCache;
        synchronized (map) {
            if (afterEachMethodCache.containsKey(clazz)) {
                return afterEachMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.AfterEach.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            afterEachMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getAfterAllMethods(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = afterAllMethodCache;
        synchronized (map) {
            if (afterAllMethodCache.containsKey(clazz)) {
                return afterAllMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.AfterAll.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            afterAllMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Method> getAfterClassMethods(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = afterClassMethodCache;
        synchronized (map) {
            if (afterClassMethodCache.containsKey(clazz)) {
                return afterClassMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.AfterClass.class, Scope.STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methodList);
            Collection<Method> methods = Collections.unmodifiableCollection(methodList);
            afterClassMethodCache.put(clazz, methods);
            return methods;
        }
    }

    private static void sortByOrderAnnotation(List<Method> methods) {
        Collections.sort(methods, (o1, o2) -> {
            boolean o1AnnotationPresent = o1.isAnnotationPresent(TestEngine.Order.class);
            boolean o2AnnotationPresent = o2.isAnnotationPresent(TestEngine.Order.class);
            if (o1AnnotationPresent) {
                if (o2AnnotationPresent) {
                    int o2Order;
                    int o1Order = o1.getAnnotation(TestEngine.Order.class).value();
                    return o1Order < (o2Order = o2.getAnnotation(TestEngine.Order.class).value()) ? -1 : (o1Order == o2Order ? 0 : 1);
                }
                return -1;
            }
            if (o2AnnotationPresent) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        });
    }

    public static boolean isBaseClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(TestEngine.BaseClass.class);
    }

    public static boolean isDisabled(Class<?> clazz) {
        return clazz.isAnnotationPresent(TestEngine.Disabled.class);
    }

    public static boolean isDisabled(Method method) {
        return method.isAnnotationPresent(TestEngine.Disabled.class);
    }

    public static TestPlan createTestPlan(TestDescriptor testDescriptor, ConfigurationParameters configurationParameters) {
        return TestPlan.from(Collections.singleton(testDescriptor), (ConfigurationParameters)configurationParameters);
    }

    private static enum Scope {
        STATIC,
        NON_STATIC;

    }
}

