/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.Optional;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.descriptor.TestEngineAbstractTestDescriptor;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class TestEngineParameterTestDescriptor
extends TestEngineAbstractTestDescriptor {
    private final Class<?> testClass;
    private final Parameter testParameter;

    public TestEngineParameterTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Parameter testParameter) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testParameter = testParameter;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testParameter.getClass()));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Parameter getTestParameter() {
        return this.testParameter;
    }

    public TestEngineParameterTestDescriptor copy() {
        TestEngineParameterTestDescriptor copy = new TestEngineParameterTestDescriptor(this.getUniqueId(), this.getDisplayName(), this.testClass, this.testParameter);
        copy.setParent((TestDescriptor)this.getParent().get());
        this.children.stream().forEach(child -> copy.addChild((TestDescriptor)child));
        return copy;
    }
}

