/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.support;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.junit.platform.engine.ConfigurationParameters;

public class TestEngineConfigurationParameters
implements ConfigurationParameters {
    private Map<String, String> configurationMap = new TreeMap<String, String>();

    public TestEngineConfigurationParameters() {
        this(null);
    }

    public TestEngineConfigurationParameters(ConfigurationParameters configurationParameters) {
        if (configurationParameters != null) {
            Set configurationKeySet = configurationParameters.keySet();
            for (String string : configurationKeySet) {
                configurationParameters.get(string).ifPresent(value -> this.configurationMap.put(key, (String)value));
            }
        }
        Properties properties = System.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            this.configurationMap.put(key, value2);
        }
    }

    public Map<String, String> getConfigurationMap() {
        return this.configurationMap;
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.configurationMap.get(key));
    }

    public Optional<Boolean> getBoolean(String key) {
        String value = this.configurationMap.get(key);
        return Optional.ofNullable(Boolean.parseBoolean(value));
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        String value = this.configurationMap.get(key);
        T t = transformer.apply(value);
        return Optional.ofNullable(t);
    }

    public int size() {
        return this.configurationMap.size();
    }

    public Set<String> keySet() {
        return this.configurationMap.keySet();
    }
}

