/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.support;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.support.TestEngineExecutionContext;
import org.antublue.test.engine.support.TestEngineUtils;
import org.antublue.test.engine.support.descriptor.TestEngineClassTestDescriptor;
import org.antublue.test.engine.support.descriptor.TestEngineParameterTestDescriptor;
import org.antublue.test.engine.support.descriptor.TestEngineTestMethodTestDescriptor;
import org.antublue.test.engine.support.logger.Logger;
import org.antublue.test.engine.support.logger.LoggerFactory;
import org.antublue.test.engine.support.util.Switch;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class TestEngineExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineExecutor.class);
    private final ExecutorService executorService;

    public TestEngineExecutor(int threadCount) {
        this.executorService = Executors.newFixedThreadPool(threadCount, new NamedThreadFactory());
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute(ExecutionRequest)");
        EngineExecutionListener engineExecutionListener = executionRequest.getEngineExecutionListener();
        TestDescriptor rootTestDescriptor = executionRequest.getRootTestDescriptor();
        if (rootTestDescriptor.getChildren().size() == 1) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            List<TestExecutionResult> testExecutionResultList = Collections.synchronizedList(new ArrayList());
            TestEngineExecutionContext testEngineExecutionContext = new TestEngineExecutionContext(engineExecutionListener, testExecutionResultList);
            TestDescriptor testDescriptor = (TestDescriptor)rootTestDescriptor.getChildren().stream().findFirst().get();
            if (LOGGER.isTraceEnabled()) {
                this.logTestHierarchy(testDescriptor, 0);
            }
            this.execute((TestEngineClassTestDescriptor)testDescriptor, testEngineExecutionContext, countDownLatch);
            return;
        }
        engineExecutionListener.executionStarted(rootTestDescriptor);
        List<TestExecutionResult> testExecutionResultList = Collections.synchronizedList(new ArrayList());
        if (LOGGER.isTraceEnabled()) {
            this.logTestHierarchy(rootTestDescriptor, 0);
        }
        TestEngineExecutionContext testEngineExecutionContext = new TestEngineExecutionContext(engineExecutionListener, testExecutionResultList);
        if (rootTestDescriptor instanceof EngineDescriptor) {
            CountDownLatch countDownLatch = new CountDownLatch(rootTestDescriptor.getChildren().size());
            if (countDownLatch.getCount() > 1L) {
                for (TestDescriptor testDescriptor : rootTestDescriptor.getChildren()) {
                    this.executorService.submit(() -> {
                        try {
                            TestEngineExecutionContext testEngineExecutionContext1 = new TestEngineExecutionContext(engineExecutionListener, testExecutionResultList);
                            this.execute((TestEngineClassTestDescriptor)testDescriptor, testEngineExecutionContext1, countDownLatch);
                        }
                        finally {
                            TestEngineExecutor.flush();
                        }
                    });
                }
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    LOGGER.error("Exception waiting for tests", e);
                }
            } else {
                this.execute((TestEngineClassTestDescriptor)((Object)rootTestDescriptor.getChildren().stream().findFirst().get()), testEngineExecutionContext, countDownLatch);
                TestEngineExecutor.flush();
            }
        }
        engineExecutionListener.executionFinished(rootTestDescriptor, TestExecutionResult.successful());
        TestEngineExecutor.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TestEngineClassTestDescriptor testEngineClassTestDescriptor, TestEngineExecutionContext testEngineExecutionContext, CountDownLatch countDownLatch) {
        LOGGER.trace("execute(TestEngineClassTestDescriptor, TestEngineExecutionContext)");
        testEngineExecutionContext.getEngineExecutionListener().executionStarted((TestDescriptor)testEngineClassTestDescriptor);
        List<TestExecutionResult> testExecutionResultList = testEngineClassTestDescriptor.getTestExecutionResultList();
        testExecutionResultList.clear();
        try {
            Class<?> testClass = testEngineClassTestDescriptor.getTestClass();
            LOGGER.trace("executing @TestEngine.BeforeClass methods...");
            for (Method beforeClass : TestEngineUtils.getBeforeClassMethods(testClass)) {
                LOGGER.trace(String.format("@TestEngine.BeforeClass method [%s]", beforeClass.getName()));
                beforeClass.invoke(null, (Object[])null);
                TestEngineExecutor.flush();
            }
            Constructor<?> testClassConstructor = testClass.getDeclaredConstructor(null);
            Object testInstance = testClassConstructor.newInstance(null);
            testEngineExecutionContext.setTestInstance(testInstance);
            Set children = testEngineClassTestDescriptor.getChildren();
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof TestEngineParameterTestDescriptor)) continue;
                TestEngineParameterTestDescriptor testEngineParameterTestDescriptor = (TestEngineParameterTestDescriptor)testDescriptor;
                this.execute(testEngineParameterTestDescriptor, testEngineExecutionContext);
                testExecutionResultList.addAll(testEngineParameterTestDescriptor.getTestExecutionResultList());
            }
            testEngineExecutionContext.setTestInstance(null);
            LOGGER.trace("executing @TestEngine.AfterClass methods...");
            for (Method afterClassMethod : TestEngineUtils.getAfterClassMethods(testClass)) {
                LOGGER.trace(String.format("@TestEngine.AfterClass method [%s]", afterClassMethod.getName()));
                afterClassMethod.invoke(null, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t) {
            t = TestEngineExecutor.resolve(t);
            TestEngineExecutor.printStackTrace(t, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t));
        }
        finally {
            TestEngineExecutor.flush();
            testEngineExecutionContext.getTestExecutionResultList().addAll(testExecutionResultList);
            if (testExecutionResultList.isEmpty()) {
                testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineClassTestDescriptor, TestExecutionResult.successful());
            } else {
                testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineClassTestDescriptor, testExecutionResultList.get(0));
            }
        }
        countDownLatch.countDown();
        TestEngineExecutor.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TestEngineParameterTestDescriptor testEngineParameterTestDescriptor, TestEngineExecutionContext testEngineExecutionContext) {
        TestDescriptor testDescriptor;
        Iterator<Object> iterator;
        Object children;
        LOGGER.trace("execute(TestEngineParameterTestDescriptor, TestEngineParameterTestDescriptor)");
        testEngineExecutionContext.getEngineExecutionListener().executionStarted((TestDescriptor)testEngineParameterTestDescriptor);
        List<TestExecutionResult> testExecutionResultList = testEngineParameterTestDescriptor.getTestExecutionResultList();
        testExecutionResultList.clear();
        Class<?> testClass = testEngineParameterTestDescriptor.getTestClass();
        Object testInstance = testEngineExecutionContext.getTestInstance();
        Parameter testParameter = testEngineParameterTestDescriptor.getTestParameter();
        try {
            LOGGER.trace("executing @TestEngine.ParameterSetter method...");
            Method testParameterSetterMethod = TestEngineUtils.getParameterSetterMethods(testClass).stream().findFirst().get();
            testParameterSetterMethod.invoke(testInstance, testParameter);
            LOGGER.trace("executing @TestEngine.BeforeAll methods...");
            for (Method beforeAllMethod : TestEngineUtils.getBeforeAllMethods(testClass)) {
                LOGGER.trace(String.format("@TestEngine.BeforeAll method [%s]", beforeAllMethod.getName()));
                beforeAllMethod.invoke(testInstance, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t) {
            t = TestEngineExecutor.resolve(t);
            TestEngineExecutor.printStackTrace(t, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t));
        }
        finally {
            TestEngineExecutor.flush();
        }
        if (testExecutionResultList.isEmpty()) {
            children = testEngineParameterTestDescriptor.getChildren();
            iterator = children.iterator();
            while (iterator.hasNext()) {
                testDescriptor = (TestDescriptor)iterator.next();
                if (!(testDescriptor instanceof TestEngineTestMethodTestDescriptor)) continue;
                TestEngineTestMethodTestDescriptor testEngineTestMethodTestDescriptor = (TestEngineTestMethodTestDescriptor)testDescriptor;
                this.execute(testEngineTestMethodTestDescriptor, testEngineExecutionContext);
                testExecutionResultList.addAll(testEngineTestMethodTestDescriptor.getTestExecutionResultList());
            }
        } else {
            children = testEngineParameterTestDescriptor.getChildren();
            iterator = children.iterator();
            while (iterator.hasNext()) {
                testDescriptor = (TestDescriptor)iterator.next();
                if (!(testDescriptor instanceof TestEngineTestMethodTestDescriptor)) continue;
                testEngineExecutionContext.getEngineExecutionListener().executionSkipped(testDescriptor, "@TestEngine.BeforeAll method exception");
            }
        }
        try {
            LOGGER.trace("executing @TestEngine.AfterAll methods...");
            for (Method afterAllMethod : TestEngineUtils.getAfterAllMethods(testClass)) {
                LOGGER.trace(String.format("@TestEngine.AfterAll method [%s]", afterAllMethod.getName()));
                afterAllMethod.invoke(testInstance, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t) {
            t = TestEngineExecutor.resolve(t);
            TestEngineExecutor.printStackTrace(t, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t));
        }
        finally {
            TestEngineExecutor.flush();
        }
        if (testExecutionResultList.isEmpty()) {
            testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineParameterTestDescriptor, TestExecutionResult.successful());
        } else {
            testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineParameterTestDescriptor, testExecutionResultList.get(0));
        }
        testEngineExecutionContext.getTestExecutionResultList().addAll(testExecutionResultList);
        TestEngineExecutor.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TestEngineTestMethodTestDescriptor testEngineTestMethodTestDescriptor, TestEngineExecutionContext testEngineExecutionContext) {
        Object t2;
        LOGGER.trace("execute(TestEngineTestMethodTestDescriptor, TestEngineExecutionContext)");
        testEngineExecutionContext.getEngineExecutionListener().executionStarted((TestDescriptor)testEngineTestMethodTestDescriptor);
        List<TestExecutionResult> testExecutionResultList = testEngineTestMethodTestDescriptor.getTestExecutionResultList();
        testExecutionResultList.clear();
        Class<?> testClass = testEngineTestMethodTestDescriptor.getTestClass();
        Object testInstance = testEngineExecutionContext.getTestInstance();
        try {
            LOGGER.trace("executing @TestEngine.BeforeEach methods...");
            for (Method beforeEachMethod : TestEngineUtils.getBeforeEachMethods(testClass)) {
                LOGGER.trace(String.format("@TestEngine.BeforeEach method [%s]", beforeEachMethod.getName()));
                beforeEachMethod.invoke(testInstance, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t2) {
            t2 = TestEngineExecutor.resolve(t2);
            TestEngineExecutor.printStackTrace((Throwable)t2, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t2));
        }
        finally {
            TestEngineExecutor.flush();
        }
        try {
            LOGGER.trace("executing @TestEngine.Test methods");
            Method testMethod = testEngineTestMethodTestDescriptor.getTestMethod();
            LOGGER.trace(String.format("@TestEngine.Test method [%s]", testMethod.getName()));
            testMethod.invoke(testInstance, (Object[])null);
            TestEngineExecutor.flush();
        }
        catch (Throwable t3) {
            t2 = TestEngineExecutor.resolve(t3);
            TestEngineExecutor.printStackTrace((Throwable)t2, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t2));
        }
        finally {
            TestEngineExecutor.flush();
        }
        try {
            LOGGER.trace("executing @TestEngine.AfterEach methods...");
            for (Method afterEachMethod : TestEngineUtils.getAfterEachMethods(testClass)) {
                LOGGER.trace(String.format("@TestEngine.AfterEach method [%s]", afterEachMethod.getName()));
                afterEachMethod.invoke(testInstance, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t4) {
            t4 = TestEngineExecutor.resolve(t4);
            TestEngineExecutor.printStackTrace(t4, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t4));
        }
        finally {
            TestEngineExecutor.flush();
        }
        if (testExecutionResultList.isEmpty()) {
            testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineTestMethodTestDescriptor, TestExecutionResult.successful());
        } else {
            testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineTestMethodTestDescriptor, testExecutionResultList.get(0));
        }
        testEngineExecutionContext.getTestExecutionResultList().addAll(testExecutionResultList);
        TestEngineExecutor.flush();
    }

    private void logTestHierarchy(TestDescriptor testDescriptor, int indent) {
        if (indent == 0) {
            LOGGER.trace("Test class hierarchy...");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            stringBuilder.append(" ");
        }
        Switch.switchType(testDescriptor, Switch.switchCase(TestEngineTestMethodTestDescriptor.class, testMethodTestDescriptor -> stringBuilder.append("method -> ").append(testMethodTestDescriptor.getTestMethod().getName()).append("()")), Switch.switchCase(TestEngineParameterTestDescriptor.class, testParameterTestDescriptor -> stringBuilder.append("parameter -> ").append(testParameterTestDescriptor.getTestParameter())), Switch.switchCase(TestEngineClassTestDescriptor.class, testClassTestDescriptor -> stringBuilder.append("class -> ").append(testClassTestDescriptor.getTestClass().getName())), Switch.switchCase(EngineDescriptor.class, engineDescriptor -> stringBuilder.append("engine -> ").append(engineDescriptor.getDisplayName())));
        LOGGER.trace(stringBuilder.toString());
        for (TestDescriptor child : testDescriptor.getChildren()) {
            this.logTestHierarchy(child, indent + 2);
        }
    }

    private static Throwable resolve(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return t.getCause();
        }
        return t;
    }

    public static void printStackTrace(Throwable t, PrintStream printStream) {
        printStream.println(t.getClass().getName() + ": " + t.getMessage());
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        if (stackTraceElements != null) {
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                if (stackTraceElement.getClassName().startsWith("org.antublue.test.engine")) break;
                printStream.println("    at " + stackTraceElement);
            }
        }
    }

    private static void flush() {
        System.err.flush();
        System.out.flush();
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private int threadId = 1;

        private NamedThreadFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Thread newThread(Runnable r) {
            String threadName;
            NamedThreadFactory namedThreadFactory = this;
            synchronized (namedThreadFactory) {
                threadName = String.format("test-engine-%02d", this.threadId);
                ++this.threadId;
            }
            Thread thread = new Thread(r);
            thread.setName(threadName);
            thread.setDaemon(true);
            return thread;
        }
    }
}

