/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.antublue.test.engine.TestEngine;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.support.descriptor.TestEngineClassTestDescriptor;
import org.antublue.test.engine.support.descriptor.TestEngineParameterTestDescriptor;
import org.antublue.test.engine.support.descriptor.TestEngineTestMethodTestDescriptor;
import org.antublue.test.engine.support.logger.Logger;
import org.antublue.test.engine.support.logger.LoggerFactory;
import org.antublue.test.engine.support.util.Switch;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class TestEngineSummaryEngineExecutionListener
implements EngineExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngine.class);
    private static final String TEST = "(TEST)";
    private static final String ABORT = "(ABORT)";
    private static final String FAIL = "(FAIL)";
    private static final String PASS = "(PASS)";
    private final TestPlan testPlan;
    private final SummaryGeneratingListener summaryGeneratingListener;
    private boolean detailedOutput = true;

    public TestEngineSummaryEngineExecutionListener(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.summaryGeneratingListener = new SummaryGeneratingListener();
        this.summaryGeneratingListener.testPlanExecutionStarted(testPlan);
        Optional optionalDetailOutput = testPlan.getConfigurationParameters().get("antublue.test.engine.output");
        optionalDetailOutput.ifPresent(s -> {
            this.detailedOutput = "detailed".equalsIgnoreCase((String)s);
        });
    }

    public void dynamicTestRegistered(TestDescriptor testDescriptor) {
        this.summaryGeneratingListener.dynamicTestRegistered(TestIdentifier.from((TestDescriptor)testDescriptor));
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.summaryGeneratingListener.executionSkipped(TestIdentifier.from((TestDescriptor)testDescriptor), reason);
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        this.summaryGeneratingListener.executionStarted(TestIdentifier.from((TestDescriptor)testDescriptor));
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(EngineDescriptor.class, consumer -> {}), Switch.switchCase(TestEngineClassTestDescriptor.class, consumer -> {}), Switch.switchCase(TestEngineParameterTestDescriptor.class, consumer -> {
            TestEngineParameterTestDescriptor testEngineParameterTestDescriptor = (TestEngineParameterTestDescriptor)testDescriptor;
            Class<?> testClass = testEngineParameterTestDescriptor.getTestClass();
            Parameter parameter = testEngineParameterTestDescriptor.getTestParameter();
            String parameterDisplayName = parameter.name();
            stringBuilder.append(parameterDisplayName).append(" | ").append(TEST).append(" ").append(testClass.getName());
        }), Switch.switchCase(TestEngineTestMethodTestDescriptor.class, consumer -> {
            TestEngineTestMethodTestDescriptor testEngineTestMethodTestDescriptor = (TestEngineTestMethodTestDescriptor)testDescriptor;
            Class<?> testClass = testEngineTestMethodTestDescriptor.getTestClass();
            Method testMethod = testEngineTestMethodTestDescriptor.getTestMethod();
            Parameter parameter = testEngineTestMethodTestDescriptor.getTestParameter();
            String parameterDisplayName = parameter.name();
            stringBuilder.append(parameterDisplayName).append(" | ").append(TEST).append(" ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
        }));
        if (this.detailedOutput && stringBuilder.length() > 0) {
            LOGGER.info(stringBuilder.toString());
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        this.summaryGeneratingListener.executionFinished(TestIdentifier.from((TestDescriptor)testDescriptor), testExecutionResult);
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(EngineDescriptor.class, consumer -> {}), Switch.switchCase(TestEngineClassTestDescriptor.class, consumer -> {}), Switch.switchCase(TestEngineParameterTestDescriptor.class, consumer -> {
            TestEngineParameterTestDescriptor testengineParameterTestDescriptor = (TestEngineParameterTestDescriptor)testDescriptor;
            Class<?> testClass = testengineParameterTestDescriptor.getTestClass();
            Parameter parameter = testengineParameterTestDescriptor.getTestParameter();
            String parameterDisplayName = parameter.name();
            stringBuilder.append(parameterDisplayName).append(" | ").append("%s ").append(testClass.getName());
        }), Switch.switchCase(TestEngineTestMethodTestDescriptor.class, consumer -> {
            TestEngineTestMethodTestDescriptor testEngineTestMethodTestDescriptor = (TestEngineTestMethodTestDescriptor)testDescriptor;
            Class<?> testClass = testEngineTestMethodTestDescriptor.getTestClass();
            Method testMethod = testEngineTestMethodTestDescriptor.getTestMethod();
            Parameter parameter = testEngineTestMethodTestDescriptor.getTestParameter();
            String parameterDisplayName = parameter.name();
            stringBuilder.append(parameterDisplayName).append(" | ").append("%s ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
        }));
        if (stringBuilder.length() > 0) {
            TestExecutionResult.Status status = testExecutionResult.getStatus();
            String string = null;
            switch (status) {
                case ABORTED: {
                    string = String.format(stringBuilder.toString(), ABORT);
                    break;
                }
                case FAILED: {
                    string = String.format(stringBuilder.toString(), FAIL);
                    break;
                }
                case SUCCESSFUL: {
                    string = String.format(stringBuilder.toString(), PASS);
                    break;
                }
            }
            if (this.detailedOutput && string != null) {
                LOGGER.info(string);
            }
        }
    }

    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        this.summaryGeneratingListener.reportingEntryPublished(TestIdentifier.from((TestDescriptor)testDescriptor), entry);
    }

    public TestExecutionSummary getSummary() {
        this.summaryGeneratingListener.testPlanExecutionFinished(this.testPlan);
        return this.summaryGeneratingListener.getSummary();
    }
}

