/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.support.api;

import java.util.Objects;
import org.antublue.test.engine.api.Parameter;

public class ParameterImpl
implements Parameter {
    private final String name;
    private final Object value;

    public ParameterImpl(String name, Object value) {
        Objects.requireNonNull(name);
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name.trim();
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> T value() {
        return (T)this.value;
    }

    @Override
    public <T> T value(Class<T> clazz) {
        return clazz.cast(this.value);
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterImpl named = (ParameterImpl)o;
        return Objects.equals(this.name, named.name) && Objects.equals(this.value, named.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

