/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestEngineConfigurationParameters;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.discovery.resolver.ClassSelectorResolver;
import org.antublue.test.engine.internal.discovery.resolver.ClasspathRootResolver;
import org.antublue.test.engine.internal.discovery.resolver.MethodSelectorResolver;
import org.antublue.test.engine.internal.discovery.resolver.PackageSelectorResolver;
import org.antublue.test.engine.internal.discovery.resolver.UniqueIdSelectorResolver;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.predicate.TestClassPredicate;
import org.antublue.test.engine.internal.predicate.TestClassTagPredicate;
import org.antublue.test.engine.internal.predicate.TestMethodPredicate;
import org.antublue.test.engine.internal.predicate.TestMethodTagPredicate;
import org.antublue.test.engine.internal.util.Cast;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class TestEngineDiscoveryRequestResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineDiscoveryRequestResolver.class);
    private final ClasspathRootResolver classpathRootResolver = new ClasspathRootResolver();
    private final PackageSelectorResolver packageSelectorResolver = new PackageSelectorResolver();
    private final ClassSelectorResolver classSelectorResolver = new ClassSelectorResolver();
    private final MethodSelectorResolver methodSelectorResolver = new MethodSelectorResolver();
    private final UniqueIdSelectorResolver uniqueIdSelectorResolver = new UniqueIdSelectorResolver();
    private final TestClassPredicate includeTestClassPredicate = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.test.class.include").map(value -> {
        LOGGER.trace(String.format("%s [%s]", "antublue.test.engine.test.class.include", value));
        return value;
    }).map(TestClassPredicate::of).orElse(null);
    private final TestClassPredicate excludeTestClassPredicate = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.test.class.exclude").map(value -> {
        LOGGER.trace(String.format("%s [%s]", "antublue.test.engine.test.class.exclude", value));
        return value;
    }).map(TestClassPredicate::of).orElse(null);
    private final TestMethodPredicate includeTestMethodPredicate = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.test.method.include").map(value -> {
        LOGGER.trace(String.format("%s [%s]", "antublue.test.engine.test.method.include", value));
        return value;
    }).map(TestMethodPredicate::of).orElse(null);
    private final TestMethodPredicate excludeTestMethodPredicate = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.test.method.exclude").map(value -> {
        LOGGER.trace(String.format("%s [%s]", "antublue.test.engine.test.method.exclude", value));
        return value;
    }).map(TestMethodPredicate::of).orElse(null);
    private final TestClassTagPredicate includeTestClassTagPredicate = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.test.class.tag.include").map(value -> {
        LOGGER.trace(String.format("%s [%s]", "antublue.test.engine.test.class.tag.include", value));
        return value;
    }).map(TestClassTagPredicate::of).orElse(null);
    private final TestClassTagPredicate excludeTestClassTagPredicate = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.test.class.tag.exclude").map(value -> {
        LOGGER.trace(String.format("%s [%s]", "antublue.test.engine.test.class.tag.exclude", value));
        return value;
    }).map(TestClassTagPredicate::of).orElse(null);
    private final TestMethodTagPredicate includeTestMethodTagPredicate = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.test.method.tag.include").map(value -> {
        LOGGER.trace(String.format("%s [%s]", "antublue.test.engine.test.method.tag.include", value));
        return value;
    }).map(TestMethodTagPredicate::of).orElse(null);
    private final TestMethodTagPredicate excludeTestMethodTagPredicate = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.test.method.tag.exclude").map(value -> {
        LOGGER.trace(String.format("%s [%s]", "antublue.test.engine.test.method.tag.exclude", value));
        return value;
    }).map(TestMethodTagPredicate::of).orElse(null);
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !TestEngineReflectionUtils.getTestMethods(clazz).isEmpty();
    };

    public void resolve(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve()");
        try {
            engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class).forEach(classpathRootSelector -> this.classpathRootResolver.resolve((ClasspathRootSelector)classpathRootSelector, engineDescriptor));
            engineDiscoveryRequest.getSelectorsByType(PackageSelector.class).forEach(packageSelector -> this.packageSelectorResolver.resolve((PackageSelector)packageSelector, engineDescriptor));
            engineDiscoveryRequest.getSelectorsByType(ClassSelector.class).forEach(classSelector -> this.classSelectorResolver.resolve((ClassSelector)classSelector, engineDescriptor));
            engineDiscoveryRequest.getSelectorsByType(MethodSelector.class).forEach(methodSelector -> this.methodSelectorResolver.resolve((MethodSelector)methodSelector, engineDescriptor));
            engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class).forEach(uniqueIdSelector -> this.uniqueIdSelectorResolver.resolve((UniqueIdSelector)uniqueIdSelector, engineDescriptor));
            this.processPackageNameFilters(engineDiscoveryRequest, engineDescriptor);
            this.processTestClassPredicates(engineDescriptor);
            this.processTestMethodPredicates(engineDescriptor);
            this.processTestClassTagPredicates(engineDescriptor);
            this.processTestMethodTagPredicates(engineDescriptor);
            if (LOGGER.isTraceEnabled()) {
                TestEngineDiscoveryRequestResolver.printTree(engineDescriptor);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestEngineException("Exception processing engine discovery request", t);
        }
    }

    private void processPackageNameFilters(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        LOGGER.trace("processPackageNameFilters");
        List packageNameFilters = engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class);
        LOGGER.trace("packageNameFilters size [%d]", (Object)packageNameFilters.size());
        for (PackageNameFilter packageNameFilter : packageNameFilters) {
            LinkedHashSet testDescriptors = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor testDescriptor : testDescriptors) {
                ClassTestDescriptor testEngineClassTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(testDescriptor));
                LinkedHashSet testDescriptors2 = new LinkedHashSet(testEngineClassTestDescriptor.getChildren());
                for (TestDescriptor testDescriptor2 : testDescriptors2) {
                    ParameterTestDescriptor testEngineParameterTestDescriptor = (ParameterTestDescriptor)((Object)Cast.cast(testDescriptor2));
                    LinkedHashSet testDescriptors3 = new LinkedHashSet(testDescriptor2.getChildren());
                    for (TestDescriptor testDescriptor3 : testDescriptors3) {
                        MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(testDescriptor3));
                        Class<?> clazz = methodTestDescriptor.getTestClass();
                        String className = clazz.getName();
                        if (!packageNameFilter.apply((Object)className).excluded()) continue;
                        methodTestDescriptor.removeFromHierarchy();
                    }
                    Class<?> clazz = testEngineParameterTestDescriptor.getTestClass();
                    String className = clazz.getName();
                    if (!packageNameFilter.apply((Object)className).excluded()) continue;
                    testEngineParameterTestDescriptor.removeFromHierarchy();
                }
                Class<?> clazz = testEngineClassTestDescriptor.getTestClass();
                String className = clazz.getName();
                if (!packageNameFilter.apply((Object)className).excluded()) continue;
                testEngineClassTestDescriptor.removeFromHierarchy();
            }
        }
        engineDescriptor.prune();
    }

    private void processTestClassPredicates(EngineDescriptor engineDescriptor) {
        Class<?> clazz;
        UniqueId uniqueId;
        ClassTestDescriptor testEngineClassTestDescriptor;
        LinkedHashSet children;
        LOGGER.trace("processTestClassPredicates");
        if (this.includeTestClassPredicate != null) {
            LOGGER.trace("includeTestClassPredicate [%s]", (Object)this.includeTestClassPredicate.getRegex());
            children = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                testEngineClassTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(child));
                uniqueId = testEngineClassTestDescriptor.getUniqueId();
                clazz = testEngineClassTestDescriptor.getTestClass();
                if (this.includeTestClassPredicate.test(clazz)) {
                    LOGGER.trace("  accept [%s]", (Object)uniqueId);
                    continue;
                }
                LOGGER.trace("  prune  [%s]", (Object)uniqueId);
                testEngineClassTestDescriptor.removeFromHierarchy();
            }
        }
        if (this.excludeTestClassPredicate != null) {
            LOGGER.trace("excludeTestClassPredicate [%s]", (Object)this.excludeTestClassPredicate.getRegex());
            children = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                testEngineClassTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(child));
                uniqueId = testEngineClassTestDescriptor.getUniqueId();
                clazz = testEngineClassTestDescriptor.getTestClass();
                if (this.excludeTestClassPredicate.test(clazz)) {
                    LOGGER.trace("  prune  [%s]", (Object)uniqueId);
                    testEngineClassTestDescriptor.removeFromHierarchy();
                    continue;
                }
                LOGGER.trace("  accept [%s]", (Object)uniqueId);
            }
        }
    }

    private void processTestMethodPredicates(EngineDescriptor engineDescriptor) {
        Method method;
        UniqueId uniqueId;
        MethodTestDescriptor methodTestDescriptor;
        LinkedHashSet greatGrandChildren;
        Set grandChildren;
        Set children;
        LOGGER.trace("processTestMethodPredicates");
        if (this.includeTestMethodPredicate != null) {
            LOGGER.trace("includeTestMethodPredicate [%s]", (Object)this.includeTestMethodPredicate.getRegex());
            children = engineDescriptor.getChildren();
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                grandChildren = child.getChildren();
                for (TestDescriptor grandChild : grandChildren) {
                    if (!(grandChild instanceof ParameterTestDescriptor)) continue;
                    greatGrandChildren = new LinkedHashSet(grandChild.getChildren());
                    for (TestDescriptor greatGrandChild : greatGrandChildren) {
                        if (!(greatGrandChild instanceof MethodTestDescriptor)) continue;
                        methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(greatGrandChild));
                        uniqueId = methodTestDescriptor.getUniqueId();
                        method = methodTestDescriptor.getTestMethod();
                        if (this.includeTestMethodPredicate.test(method)) {
                            LOGGER.trace("  accept [%s]", (Object)uniqueId);
                            continue;
                        }
                        LOGGER.trace("  prune  [%s]", (Object)uniqueId);
                        methodTestDescriptor.removeFromHierarchy();
                    }
                }
            }
        }
        if (this.excludeTestMethodPredicate != null) {
            LOGGER.trace("excludeTestMethodPredicate [%s]", (Object)this.excludeTestMethodPredicate.getRegex());
            children = engineDescriptor.getChildren();
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                grandChildren = child.getChildren();
                for (TestDescriptor grandChild : grandChildren) {
                    if (!(grandChild instanceof ParameterTestDescriptor)) continue;
                    greatGrandChildren = new LinkedHashSet(grandChild.getChildren());
                    for (TestDescriptor greatGrandChild : greatGrandChildren) {
                        if (!(greatGrandChild instanceof MethodTestDescriptor)) continue;
                        methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(greatGrandChild));
                        uniqueId = methodTestDescriptor.getUniqueId();
                        method = methodTestDescriptor.getTestMethod();
                        if (this.excludeTestMethodPredicate.test(method)) {
                            LOGGER.trace("  prune  [%s]", (Object)uniqueId);
                            methodTestDescriptor.removeFromHierarchy();
                            continue;
                        }
                        LOGGER.trace("  accept [%s]", (Object)uniqueId);
                    }
                }
            }
        }
    }

    private void processTestClassTagPredicates(EngineDescriptor engineDescriptor) {
        Class<?> clazz;
        UniqueId uniqueId;
        ClassTestDescriptor testEngineClassTestDescriptor;
        LinkedHashSet children;
        LOGGER.trace("processTestClassTagPredicates");
        if (this.includeTestClassTagPredicate != null) {
            LOGGER.trace("includeTestClassTagPredicate [%s]", (Object)this.includeTestClassTagPredicate.getRegex());
            children = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                testEngineClassTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(child));
                uniqueId = testEngineClassTestDescriptor.getUniqueId();
                clazz = testEngineClassTestDescriptor.getTestClass();
                if (this.includeTestClassTagPredicate.test(clazz)) {
                    LOGGER.trace("  accept [%s]", (Object)uniqueId);
                    continue;
                }
                LOGGER.trace("  prune  [%s]", (Object)uniqueId);
                testEngineClassTestDescriptor.removeFromHierarchy();
            }
        }
        if (this.excludeTestClassTagPredicate != null) {
            LOGGER.trace("excludeTestClassTagPredicate [%s]", (Object)this.excludeTestClassTagPredicate.getRegex());
            children = new LinkedHashSet(engineDescriptor.getChildren());
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                testEngineClassTestDescriptor = (ClassTestDescriptor)((Object)Cast.cast(child));
                uniqueId = testEngineClassTestDescriptor.getUniqueId();
                clazz = testEngineClassTestDescriptor.getTestClass();
                if (this.excludeTestClassTagPredicate.test(clazz)) {
                    LOGGER.trace("  prune  [%s]", (Object)uniqueId);
                    testEngineClassTestDescriptor.removeFromHierarchy();
                    continue;
                }
                LOGGER.trace("  accept [%s]", (Object)uniqueId);
            }
        }
    }

    private void processTestMethodTagPredicates(EngineDescriptor engineDescriptor) {
        Method method;
        UniqueId uniqueId;
        MethodTestDescriptor methodTestDescriptor;
        LinkedHashSet greatGrandChildren;
        Set grandChildren;
        Set children;
        LOGGER.trace("processTestMethodTagPredicates");
        if (this.includeTestMethodTagPredicate != null) {
            LOGGER.trace("includeTestMethodTagPredicate [%s]", (Object)this.includeTestMethodTagPredicate.getRegex());
            children = engineDescriptor.getChildren();
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                grandChildren = child.getChildren();
                for (TestDescriptor grandChild : grandChildren) {
                    if (!(grandChild instanceof ParameterTestDescriptor)) continue;
                    greatGrandChildren = new LinkedHashSet(grandChild.getChildren());
                    for (TestDescriptor greatGrandChild : greatGrandChildren) {
                        if (!(greatGrandChild instanceof MethodTestDescriptor)) continue;
                        methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(greatGrandChild));
                        uniqueId = methodTestDescriptor.getUniqueId();
                        method = methodTestDescriptor.getTestMethod();
                        if (this.includeTestMethodTagPredicate.test(method)) {
                            LOGGER.trace("  accept [%s]", (Object)uniqueId);
                            continue;
                        }
                        LOGGER.trace("  prune  [%s]", (Object)uniqueId);
                        methodTestDescriptor.removeFromHierarchy();
                    }
                }
            }
        }
        if (this.excludeTestMethodTagPredicate != null) {
            LOGGER.trace("excludeTestMethodTagPredicate [%s]", (Object)this.excludeTestMethodTagPredicate.getRegex());
            children = engineDescriptor.getChildren();
            for (TestDescriptor child : children) {
                if (!(child instanceof ClassTestDescriptor)) continue;
                grandChildren = child.getChildren();
                for (TestDescriptor grandChild : grandChildren) {
                    if (!(grandChild instanceof ParameterTestDescriptor)) continue;
                    greatGrandChildren = new LinkedHashSet(grandChild.getChildren());
                    for (TestDescriptor greatGrandChild : greatGrandChildren) {
                        if (!(greatGrandChild instanceof MethodTestDescriptor)) continue;
                        methodTestDescriptor = (MethodTestDescriptor)((Object)Cast.cast(greatGrandChild));
                        uniqueId = methodTestDescriptor.getUniqueId();
                        method = methodTestDescriptor.getTestMethod();
                        if (this.excludeTestMethodTagPredicate.test(method)) {
                            LOGGER.trace("  prune  [%s]", (Object)uniqueId);
                            methodTestDescriptor.removeFromHierarchy();
                            continue;
                        }
                        LOGGER.trace("  accept [%s]", (Object)uniqueId);
                    }
                }
            }
        }
    }

    private static void printTree(EngineDescriptor engineDescriptor) {
        LOGGER.trace("EngineDescriptor - > " + engineDescriptor.getUniqueId());
        Set testDescriptors = engineDescriptor.getChildren();
        for (TestDescriptor testDescriptor : testDescriptors) {
            TestEngineDiscoveryRequestResolver.printTree(testDescriptor, 2);
        }
    }

    private static void printTree(TestDescriptor parentTestDescriptor, int indent) {
        if (parentTestDescriptor instanceof ClassTestDescriptor) {
            LOGGER.trace(TestEngineDiscoveryRequestResolver.pad(indent) + "ClassTestDescriptor - > " + parentTestDescriptor.getUniqueId());
            Set testDescriptors = ((ClassTestDescriptor)parentTestDescriptor).getChildren();
            for (TestDescriptor childTestDescriptor : testDescriptors) {
                TestEngineDiscoveryRequestResolver.printTree(childTestDescriptor, indent + 2);
            }
        } else if (parentTestDescriptor instanceof ParameterTestDescriptor) {
            LOGGER.trace(TestEngineDiscoveryRequestResolver.pad(indent) + "ParameterTestDescriptor - > " + parentTestDescriptor.getUniqueId());
            Set testDescriptors = ((ParameterTestDescriptor)parentTestDescriptor).getChildren();
            for (TestDescriptor childTestDescriptor : testDescriptors) {
                TestEngineDiscoveryRequestResolver.printTree(childTestDescriptor, indent + 2);
            }
        } else {
            LOGGER.trace(TestEngineDiscoveryRequestResolver.pad(indent) + "MethodTestDescriptor - > " + parentTestDescriptor.getUniqueId());
        }
    }

    private static String pad(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

