/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import org.antublue.test.engine.TestEngine;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineConfigurationParameters;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Switch;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class TestEngineSummaryEngineExecutionListener
implements EngineExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngine.class);
    private static final String TEST = "TEST";
    private static final String ABORT = "ABORT";
    private static final String FAIL = "FAIL";
    private static final String PASS = "PASS";
    private final TestPlan testPlan;
    private final SummaryGeneratingListener summaryGeneratingListener;
    private final boolean detailedOutput;
    private final boolean logTestMessages;
    private final boolean logPassMessages;

    public TestEngineSummaryEngineExecutionListener(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.summaryGeneratingListener = new SummaryGeneratingListener();
        this.summaryGeneratingListener.testPlanExecutionStarted(testPlan);
        this.detailedOutput = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.console.output").map(value -> {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }).orElse(false);
        this.logTestMessages = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.experimental.log.test.messages").map(value -> {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                return true;
            }
        }).orElse(true);
        this.logPassMessages = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.experimental.log.pass.messages").map(value -> {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                return true;
            }
        }).orElse(true);
    }

    public void dynamicTestRegistered(TestDescriptor testDescriptor) {
        this.summaryGeneratingListener.dynamicTestRegistered(TestIdentifier.from((TestDescriptor)testDescriptor));
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.summaryGeneratingListener.executionSkipped(TestIdentifier.from((TestDescriptor)testDescriptor), reason);
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof MethodTestDescriptor) {
            this.summaryGeneratingListener.executionStarted(TestIdentifier.from((TestDescriptor)testDescriptor));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(EngineDescriptor.class, consumer -> {}), Switch.switchCase(ClassTestDescriptor.class, consumer -> {}), Switch.switchCase(ParameterTestDescriptor.class, consumer -> {
            if (this.logTestMessages) {
                ParameterTestDescriptor testEngineParameterTestDescriptor = (ParameterTestDescriptor)testDescriptor;
                Class<?> testClass = testEngineParameterTestDescriptor.getTestClass();
                Parameter testParameter = testEngineParameterTestDescriptor.getTestParameter();
                String testParameterName = testParameter.name();
                stringBuilder.append(TEST).append(" | ").append(testParameterName).append(" | ").append(testClass.getName());
            }
        }), Switch.switchCase(MethodTestDescriptor.class, consumer -> {
            if (this.logTestMessages) {
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                Class<?> testClass = methodTestDescriptor.getTestClass();
                Method testMethod = methodTestDescriptor.getTestMethod();
                Parameter testParameter = methodTestDescriptor.getTestParameter();
                String testParameterName = testParameter.name();
                stringBuilder.append(TEST).append(" | ").append(testParameterName).append(" | ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
            }
        }));
        if (this.detailedOutput && stringBuilder.length() > 0) {
            LOGGER.rawInfo(stringBuilder.toString(), new Object[0]);
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        if (testDescriptor instanceof MethodTestDescriptor) {
            this.summaryGeneratingListener.executionFinished(TestIdentifier.from((TestDescriptor)testDescriptor), testExecutionResult);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Switch.switchType(testDescriptor, Switch.switchCase(EngineDescriptor.class, consumer -> {}), Switch.switchCase(ClassTestDescriptor.class, consumer -> {}), Switch.switchCase(ParameterTestDescriptor.class, consumer -> {
            if (this.logPassMessages) {
                ParameterTestDescriptor testengineParameterTestDescriptor = (ParameterTestDescriptor)testDescriptor;
                Class<?> testClass = testengineParameterTestDescriptor.getTestClass();
                Parameter testParameter = testengineParameterTestDescriptor.getTestParameter();
                String testParameterName = testParameter.name();
                stringBuilder.append("%s | ").append(testParameterName).append(" | ").append(testClass.getName());
            }
        }), Switch.switchCase(MethodTestDescriptor.class, consumer -> {
            if (this.logPassMessages) {
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                Class<?> testClass = methodTestDescriptor.getTestClass();
                Method testMethod = methodTestDescriptor.getTestMethod();
                Parameter testParameter = methodTestDescriptor.getTestParameter();
                String testParameterName = testParameter.name();
                stringBuilder.append("%s | ").append(testParameterName).append(" | ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
            }
        }));
        if (stringBuilder.length() > 0) {
            TestExecutionResult.Status status = testExecutionResult.getStatus();
            String string = null;
            switch (status) {
                case ABORTED: {
                    string = String.format(stringBuilder.toString(), ABORT);
                    break;
                }
                case FAILED: {
                    string = String.format(stringBuilder.toString(), FAIL);
                    break;
                }
                case SUCCESSFUL: {
                    string = String.format(stringBuilder.toString(), PASS);
                    break;
                }
            }
            if (this.detailedOutput && string != null) {
                LOGGER.rawInfo(string, new Object[0]);
            }
        }
    }

    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        this.summaryGeneratingListener.reportingEntryPublished(TestIdentifier.from((TestDescriptor)testDescriptor), entry);
    }

    public TestExecutionSummary getSummary() {
        this.summaryGeneratingListener.testPlanExecutionFinished(this.testPlan);
        return this.summaryGeneratingListener.getSummary();
    }
}

