/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.descriptor.UriSource;

public class MethodTestDescriptor
extends AbstractTestDescriptor {
    private final Class<?> testClass;
    private final Parameter testParameter;
    private final Method testMethod;

    public MethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Parameter testParameter, Method testMethod) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testParameter = testParameter;
        this.testMethod = testMethod;
        this.testMethod.setAccessible(true);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Parameter getTestParameter() {
        return this.testParameter;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public static class CustomUriSource
    implements UriSource {
        private final Class<?> testClass;
        private final Method testMethod;
        private final Parameter testParameter;

        private CustomUriSource(Class<?> testClass, Method testMethod, Parameter testParameter) {
            this.testClass = testClass;
            this.testMethod = testMethod;
            this.testParameter = testParameter;
        }

        public Class<?> getJavaClass() {
            return this.testClass;
        }

        public Method getJavaMethod() {
            return this.testMethod;
        }

        public String getMethodName() {
            return this.testMethod.getName();
        }

        public String getMethodParameterTypes() {
            return null;
        }

        public URI getUri() {
            try {
                return new URI("urn:" + this.testMethod.getName() + "/" + this.testParameter.hashCode());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

