/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestDescriptorFactory;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Cast;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class UniqueIdSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueIdSelectorResolver.class);

    public void resolve(UniqueIdSelector uniqueIdSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace(String.format("resolve [%s]", uniqueIdSelector.getUniqueId()));
        String className = null;
        try {
            UniqueId selectorUniqueId = uniqueIdSelector.getUniqueId();
            LOGGER.trace("selectorUniqueId [%s]", (Object)selectorUniqueId);
            UniqueId.Segment segment = selectorUniqueId.getLastSegment();
            if ("parameter".equals(segment.getType())) {
                LOGGER.trace("parameter [%s] selected", (Object)segment.getValue());
                UniqueId classUniqueId = selectorUniqueId.removeLastSegment();
                UniqueId.Segment classSegment = classUniqueId.getLastSegment();
                className = classSegment.getValue();
                LOGGER.trace("className [%s]", (Object)className);
                Class<?> clazz = Class.forName(className);
                Optional optionalTestDescriptor = engineDescriptor.findByUniqueId(classUniqueId);
                ClassTestDescriptor classTestDescriptor = optionalTestDescriptor.isPresent() ? (ClassTestDescriptor)((Object)Cast.cast(optionalTestDescriptor.get())) : TestDescriptorFactory.creaateClassTestDescriptor(classUniqueId, clazz);
                List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
                Parameter parameter = parameters.get(Integer.parseInt(segment.getValue()));
                optionalTestDescriptor = classTestDescriptor.findByUniqueId(selectorUniqueId);
                ParameterTestDescriptor parameterTestDescriptor = optionalTestDescriptor.isPresent() ? (ParameterTestDescriptor)((Object)Cast.cast(optionalTestDescriptor.get())) : TestDescriptorFactory.createParameterTestDescriptor(selectorUniqueId, clazz, parameter);
                List<Method> methods = TestEngineReflectionUtils.getTestMethods(clazz);
                for (Method method : methods) {
                    UniqueId methodUniqueId = selectorUniqueId.append("method", method.getName());
                    MethodTestDescriptor methodTestDescriptor = TestDescriptorFactory.createMethodTestDescriptor(methodUniqueId, clazz, parameter, method);
                    parameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                }
                classTestDescriptor.addChild((TestDescriptor)parameterTestDescriptor);
                engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            } else if ("class".equals(segment.getType())) {
                className = segment.getValue();
                LOGGER.trace("className [%s]", (Object)className);
                Class<?> clazz = Class.forName(className);
                Optional optionalTestDescriptor = engineDescriptor.findByUniqueId(selectorUniqueId);
                ClassTestDescriptor classTestDescriptor = optionalTestDescriptor.isPresent() ? (ClassTestDescriptor)((Object)Cast.cast(optionalTestDescriptor.get())) : TestDescriptorFactory.creaateClassTestDescriptor(selectorUniqueId, clazz);
                List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
                for (int i = 0; i < parameters.size(); ++i) {
                    Parameter parameter = parameters.get(i);
                    UniqueId parameterUniqueId = selectorUniqueId.append("parameter", String.valueOf(i));
                    ParameterTestDescriptor parameterTestDescriptor = TestDescriptorFactory.createParameterTestDescriptor(parameterUniqueId, clazz, parameter);
                    List<Method> methods = TestEngineReflectionUtils.getTestMethods(clazz);
                    for (Method method : methods) {
                        UniqueId methodUniqueId = parameterUniqueId.append("method", method.getName());
                        MethodTestDescriptor methodTestDescriptor = TestDescriptorFactory.createMethodTestDescriptor(methodUniqueId, clazz, parameter, method);
                        parameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                    }
                    classTestDescriptor.addChild((TestDescriptor)parameterTestDescriptor);
                }
                engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            }
        }
        catch (ClassNotFoundException e) {
            throw new TestEngineException(String.format("Class [%s] not found", className), e);
        }
    }
}

