/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.predicate;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.predicate.RegexPredicate;

public final class TestClassTagPredicate
extends RegexPredicate<Class<?>> {
    private TestClassTagPredicate(String regex) {
        super(regex);
    }

    @Override
    public boolean test(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(TestEngine.Tag.class)) {
            return false;
        }
        try {
            TestEngine.Tag annotation = clazz.getAnnotation(TestEngine.Tag.class);
            Class<? extends Annotation> type = annotation.annotationType();
            Method valueMethod = type.getDeclaredMethod("value", null);
            String tag = valueMethod.invoke((Object)annotation, (Object[])null).toString();
            return this.matcher.reset(tag).find();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new TestEngineException(String.format("Invalid @TestEngine.Tag configuration", e));
        }
    }

    public static TestClassTagPredicate of(String regex) {
        return new TestClassTagPredicate(regex);
    }
}

