/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import org.antublue.test.engine.TestEngine;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineConfigurationParameters;
import org.antublue.test.engine.internal.TestEngineTestDescriptorStore;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.util.AnsiColor;
import org.antublue.test.engine.internal.util.HumanReadableTime;
import org.antublue.test.engine.internal.util.Switch;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class TestEngineTestExecutionListener
extends SummaryGeneratingListener {
    private static final String INFO = AnsiColor.WHITE_BRIGHT.apply("[") + AnsiColor.BLUE_BOLD.apply("INFO") + AnsiColor.WHITE_BRIGHT.apply("]");
    private static final String TEST = AnsiColor.WHITE_BRIGHT.apply("TEST");
    private static final String ABORT = AnsiColor.YELLOW_BOLD.apply("ABORT");
    private static final String FAIL = AnsiColor.RED_BOLD.apply("FAIL");
    private static final String PASS = AnsiColor.GREEN_BOLD.apply("PASS");
    private static final String SEPARATOR = AnsiColor.WHITE_BRIGHT.apply("------------------------------------------------------------------------");
    private final boolean detailedOutput = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.console.output").map(value -> {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }).orElse(true);
    private final boolean logTestMessages = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.experimental.log.test.messages").map(value -> {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }).orElse(true);
    private final boolean logPassMessages = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.experimental.log.pass.messages").map(value -> {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }).orElse(true);
    private TestPlan testPlan;
    private long startTimeMilliseconds;

    public void testPlanExecutionStarted(TestPlan testPlan) {
        super.testPlanExecutionStarted(testPlan);
        this.testPlan = testPlan;
        this.startTimeMilliseconds = System.currentTimeMillis();
        String banner = "Antu" + AnsiColor.BLUE_BOLD_BRIGHT.apply("BLUE") + " Test Engine " + TestEngine.VERSION;
        System.out.println(INFO + " " + SEPARATOR);
        System.out.println(INFO + " " + banner);
        System.out.println(INFO + " " + SEPARATOR);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        super.executionStarted(testIdentifier);
        TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
        if (testDescriptor != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Switch.switchType(testDescriptor, Switch.switchCase(EngineDescriptor.class, consumer -> {}), Switch.switchCase(ClassTestDescriptor.class, consumer -> {}), Switch.switchCase(ParameterTestDescriptor.class, consumer -> {
                if (this.logTestMessages) {
                    ParameterTestDescriptor testEngineParameterTestDescriptor = (ParameterTestDescriptor)testDescriptor;
                    Class<?> testClass = testEngineParameterTestDescriptor.getTestClass();
                    Parameter testParameter = testEngineParameterTestDescriptor.getTestParameter();
                    String testParameterName = testParameter.name();
                    stringBuilder.append(TEST).append(" | ").append(testParameterName).append(" | ").append(testClass.getName());
                }
            }), Switch.switchCase(MethodTestDescriptor.class, consumer -> {
                if (this.logTestMessages) {
                    MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                    Class<?> testClass = methodTestDescriptor.getTestClass();
                    Method testMethod = methodTestDescriptor.getTestMethod();
                    Parameter testParameter = methodTestDescriptor.getTestParameter();
                    String testParameterName = testParameter.name();
                    stringBuilder.append(TEST).append(" | ").append(testParameterName).append(" | ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
                }
            }));
            if (this.detailedOutput && stringBuilder.length() > 0) {
                System.out.println(INFO + " " + Thread.currentThread().getName() + " | " + stringBuilder);
            }
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        super.executionFinished(testIdentifier, testExecutionResult);
        TestDescriptor testDescriptor = TestEngineTestDescriptorStore.getInstance().get(testIdentifier.getUniqueIdObject()).orElse(null);
        if (testDescriptor != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Switch.switchType(testDescriptor, Switch.switchCase(EngineDescriptor.class, consumer -> {}), Switch.switchCase(ClassTestDescriptor.class, consumer -> {}), Switch.switchCase(ParameterTestDescriptor.class, consumer -> {
                if (this.logPassMessages) {
                    ParameterTestDescriptor testengineParameterTestDescriptor = (ParameterTestDescriptor)testDescriptor;
                    Class<?> testClass = testengineParameterTestDescriptor.getTestClass();
                    Parameter testParameter = testengineParameterTestDescriptor.getTestParameter();
                    String testParameterName = testParameter.name();
                    stringBuilder.append("%s | ").append(testParameterName).append(" | ").append(testClass.getName());
                }
            }), Switch.switchCase(MethodTestDescriptor.class, consumer -> {
                if (this.logPassMessages) {
                    MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                    Class<?> testClass = methodTestDescriptor.getTestClass();
                    Method testMethod = methodTestDescriptor.getTestMethod();
                    Parameter testParameter = methodTestDescriptor.getTestParameter();
                    String testParameterName = testParameter.name();
                    stringBuilder.append("%s | ").append(testParameterName).append(" | ").append(testClass.getName()).append(" ").append(testMethod.getName()).append("()");
                }
            }));
            if (stringBuilder.length() > 0) {
                TestExecutionResult.Status status = testExecutionResult.getStatus();
                String string = null;
                switch (status) {
                    case ABORTED: {
                        string = String.format(stringBuilder.toString(), ABORT);
                        break;
                    }
                    case FAILED: {
                        string = String.format(stringBuilder.toString(), FAIL);
                        break;
                    }
                    case SUCCESSFUL: {
                        string = String.format(stringBuilder.toString(), PASS);
                        break;
                    }
                }
                if (this.detailedOutput && string != null) {
                    System.out.println(INFO + " " + Thread.currentThread().getName() + " | " + string);
                }
            }
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        boolean failed;
        super.testPlanExecutionFinished(testPlan);
        long endTimeMilliseconds = System.currentTimeMillis();
        TestExecutionSummary testExecutionSummary = this.getSummary();
        String banner = "Antu" + AnsiColor.BLUE_BOLD_BRIGHT.apply("BLUE") + " Test Engine " + TestEngine.VERSION + " Summary";
        System.out.println(INFO + " " + SEPARATOR);
        System.out.println(INFO + " " + banner);
        System.out.println(INFO + " " + SEPARATOR);
        System.out.println(INFO + " " + AnsiColor.WHITE_BRIGHT.apply("TESTS") + " : " + (testExecutionSummary.getTestsFoundCount() + testExecutionSummary.getContainersFailedCount()) + ", " + AnsiColor.GREEN_BOLD_BRIGHT.apply("PASSED") + " : " + (testExecutionSummary.getTestsSucceededCount() - testExecutionSummary.getContainersFailedCount()) + ", " + AnsiColor.RED_BOLD_BRIGHT.apply("FAILED") + " : " + (testExecutionSummary.getTestsFailedCount() + testExecutionSummary.getContainersFailedCount()) + ", " + AnsiColor.YELLOW_BOLD_BRIGHT.apply("SKIPPED") + " : " + testExecutionSummary.getTestsSkippedCount());
        System.out.println(INFO + " " + SEPARATOR);
        boolean bl = failed = testExecutionSummary.getTestsFailedCount() + testExecutionSummary.getContainersFailedCount() > 0L;
        if (failed) {
            System.out.println(INFO + " " + AnsiColor.RED_BOLD_BRIGHT.apply("FAILED"));
        } else {
            System.out.println(INFO + " " + AnsiColor.GREEN_BOLD.apply("PASSED"));
        }
        System.out.println(INFO + " " + SEPARATOR);
        System.out.println(INFO + " Total Test Time : " + HumanReadableTime.toHumanReadable(endTimeMilliseconds - this.startTimeMilliseconds, false));
        System.out.println(INFO + " Finished At     : " + HumanReadableTime.now());
    }
}

