/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Method;
import java.util.List;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestDescriptorFactory;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class ClassSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassSelectorResolver.class);

    public void resolve(ClassSelector classSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace(String.format("resolve [%s]", classSelector.getClassName()));
        UniqueId uniqueId = engineDescriptor.getUniqueId();
        Class clazz = classSelector.getJavaClass();
        LOGGER.trace(String.format("  class [%s]", clazz.getName()));
        uniqueId = uniqueId.append("class", clazz.getName());
        ClassTestDescriptor testEngineClassTestDescriptor = TestDescriptorFactory.creaateClassTestDescriptor(uniqueId, clazz);
        engineDescriptor.addChild((TestDescriptor)testEngineClassTestDescriptor);
        List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.get(i);
            uniqueId = uniqueId.append("parameter", String.valueOf(i));
            ParameterTestDescriptor testEngineParameterTestDescriptor = TestDescriptorFactory.createParameterTestDescriptor(uniqueId, clazz, parameter);
            testEngineClassTestDescriptor.addChild((TestDescriptor)testEngineParameterTestDescriptor);
            List<Method> methods = TestEngineReflectionUtils.getTestMethods(clazz);
            for (Method method : methods) {
                uniqueId = uniqueId.append("method", method.getName());
                MethodTestDescriptor methodTestDescriptor = TestDescriptorFactory.createMethodTestDescriptor(uniqueId, clazz, parameter, method);
                testEngineParameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                uniqueId = uniqueId.removeLastSegment();
            }
            testEngineParameterTestDescriptor.prune();
            uniqueId = uniqueId.removeLastSegment();
        }
    }
}

