/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.time.Duration;

public final class Timer {
    private final boolean autoStart;
    private long startMs;
    private long stopMs;

    public Timer() {
        this(true);
    }

    public Timer(boolean autoStart) {
        this.autoStart = autoStart;
        if (autoStart) {
            this.start();
        }
    }

    public Timer start() {
        this.stopMs = this.startMs = System.currentTimeMillis();
        return this;
    }

    public Timer stop() {
        this.stopMs = System.currentTimeMillis();
        return this;
    }

    public Duration duration() {
        return Duration.ofMillis(this.stopMs - this.startMs);
    }
}

