/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.junit.platform.engine.ConfigurationParameters;

public final class TestEngineConfigurationParameters
implements ConfigurationParameters {
    private static final TestEngineConfigurationParameters INSTANCE = new TestEngineConfigurationParameters();
    private final Map<String, String> map = new LinkedHashMap<String, String>();

    private TestEngineConfigurationParameters() {
    }

    public void put(String key, String value) {
        this.map.put(key, value);
    }

    public Map<String, String> getConfigurationMap() {
        throw new UnsupportedOperationException();
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.resolve(key));
    }

    public Optional<Boolean> getBoolean(String key) {
        return Optional.ofNullable(Boolean.parseBoolean(this.resolve(key)));
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        String value = this.resolve(key);
        T t = transformer.apply(value);
        return Optional.ofNullable(t);
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    public static TestEngineConfigurationParameters getInstance() {
        return INSTANCE;
    }

    private String resolve(String key) {
        String mapValue = this.map.get(key);
        if (mapValue != null) {
            return mapValue;
        }
        String environmentVariableValue = System.getenv(key.toUpperCase(Locale.ENGLISH).replace('.', '_'));
        String systemPropertyValue = System.getProperty(key);
        if (environmentVariableValue != null && !environmentVariableValue.trim().isEmpty()) {
            return environmentVariableValue;
        }
        if (systemPropertyValue != null && !systemPropertyValue.trim().isEmpty()) {
            return systemPropertyValue;
        }
        return null;
    }
}

