/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineConfigurationParameters;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineExecutionContext;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Switch;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class TestEngineExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineExecutor.class);
    private final ExecutorService executorService;

    public TestEngineExecutor() {
        int threadCount = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.thread.count").map(value -> {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue >= 1) {
                    return intValue;
                }
                throw new TestEngineException(String.format("Invalid thread count [%d]", intValue));
            }
            catch (NumberFormatException e) {
                throw new TestEngineException(String.format("Invalid thread count [%s]", value), e);
            }
        }).orElse(Runtime.getRuntime().availableProcessors());
        LOGGER.trace("thread count [%d]", (Object)threadCount);
        this.executorService = Executors.newFixedThreadPool(threadCount, new NamedThreadFactory());
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute(ExecutionRequest)");
        if (executionRequest.getRootTestDescriptor().getChildren().size() < 1) {
            return;
        }
        EngineExecutionListener engineExecutionListener = executionRequest.getEngineExecutionListener();
        TestDescriptor rootTestDescriptor = executionRequest.getRootTestDescriptor();
        if (rootTestDescriptor.getChildren().size() == 1) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            List<TestExecutionResult> testExecutionResultList = Collections.synchronizedList(new ArrayList());
            TestEngineExecutionContext testEngineExecutionContext = new TestEngineExecutionContext(engineExecutionListener, testExecutionResultList);
            TestDescriptor testDescriptor = (TestDescriptor)rootTestDescriptor.getChildren().stream().findFirst().get();
            if (LOGGER.isTraceEnabled()) {
                this.printTestHierarchy(testDescriptor, 0);
            }
            this.execute((ClassTestDescriptor)testDescriptor, testEngineExecutionContext, countDownLatch);
            return;
        }
        engineExecutionListener.executionStarted(rootTestDescriptor);
        List<TestExecutionResult> testExecutionResultList = Collections.synchronizedList(new ArrayList());
        if (LOGGER.isTraceEnabled()) {
            this.printTestHierarchy(rootTestDescriptor, 0);
        }
        TestEngineExecutionContext testEngineExecutionContext = new TestEngineExecutionContext(engineExecutionListener, testExecutionResultList);
        if (rootTestDescriptor instanceof EngineDescriptor) {
            CountDownLatch countDownLatch = new CountDownLatch(rootTestDescriptor.getChildren().size());
            if (countDownLatch.getCount() > 1L) {
                for (TestDescriptor testDescriptor : rootTestDescriptor.getChildren()) {
                    this.executorService.submit(() -> {
                        try {
                            TestEngineExecutionContext testEngineExecutionContext1 = new TestEngineExecutionContext(engineExecutionListener, testExecutionResultList);
                            this.execute((ClassTestDescriptor)testDescriptor, testEngineExecutionContext1, countDownLatch);
                        }
                        finally {
                            TestEngineExecutor.flush();
                        }
                    });
                }
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    LOGGER.error("Exception waiting for tests", e);
                }
            } else {
                this.execute((ClassTestDescriptor)((Object)rootTestDescriptor.getChildren().stream().findFirst().get()), testEngineExecutionContext, countDownLatch);
                TestEngineExecutor.flush();
            }
        }
        engineExecutionListener.executionFinished(rootTestDescriptor, TestExecutionResult.successful());
        TestEngineExecutor.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ClassTestDescriptor testEngineClassTestDescriptor, TestEngineExecutionContext testEngineExecutionContext, CountDownLatch countDownLatch) {
        LOGGER.trace("execute(TestEngineClassTestDescriptor, TestEngineExecutionContext)");
        testEngineExecutionContext.getEngineExecutionListener().executionStarted((TestDescriptor)testEngineClassTestDescriptor);
        List testExecutionResultList = testEngineClassTestDescriptor.getTestExecutionResultList();
        testExecutionResultList.clear();
        try {
            Class<?> testClass = testEngineClassTestDescriptor.getTestClass();
            String testClassName = testClass.getName();
            LOGGER.trace("invoking [%s] @TestEngine.BeforeClass methods ...", (Object)testClassName);
            for (Method beforeClass : TestEngineReflectionUtils.getBeforeClassMethods(testClass)) {
                LOGGER.trace(String.format("invoking [%s] @TestEngine.BeforeClass method [%s] ...", testClassName, beforeClass.getName()));
                beforeClass.invoke(null, (Object[])null);
                TestEngineExecutor.flush();
            }
            Constructor<?> testClassConstructor = testClass.getDeclaredConstructor(null);
            Object testInstance = testClassConstructor.newInstance(null);
            testEngineExecutionContext.setTestInstance(testInstance);
            Set children = testEngineClassTestDescriptor.getChildren();
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof ParameterTestDescriptor)) continue;
                ParameterTestDescriptor testEngineParameterTestDescriptor = (ParameterTestDescriptor)testDescriptor;
                this.execute(testEngineParameterTestDescriptor, testEngineExecutionContext);
                testExecutionResultList.addAll(testEngineParameterTestDescriptor.getTestExecutionResultList());
            }
            testEngineExecutionContext.setTestInstance(null);
            LOGGER.trace("invoking [%s] @TestEngine.AfterClass methods ...", (Object)testClassName);
            for (Method afterClassMethod : TestEngineReflectionUtils.getAfterClassMethods(testClass)) {
                LOGGER.trace(String.format("invoking [%s] @TestEngine.AfterClass method [%s] ...", testClassName, afterClassMethod.getName()));
                afterClassMethod.invoke(null, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t) {
            t = TestEngineExecutor.resolve(t);
            TestEngineExecutor.printStackTrace(t, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t));
        }
        finally {
            TestEngineExecutor.flush();
            testEngineExecutionContext.getTestExecutionResultList().addAll(testExecutionResultList);
            if (testExecutionResultList.isEmpty()) {
                testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineClassTestDescriptor, TestExecutionResult.successful());
            } else {
                testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineClassTestDescriptor, (TestExecutionResult)testExecutionResultList.get(0));
            }
        }
        countDownLatch.countDown();
        TestEngineExecutor.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ParameterTestDescriptor testEngineParameterTestDescriptor, TestEngineExecutionContext testEngineExecutionContext) {
        Object children;
        Iterator testParameterMethods;
        LOGGER.trace("execute(TestEngineParameterTestDescriptor, TestEngineExecutionContext)");
        testEngineExecutionContext.getEngineExecutionListener().executionStarted((TestDescriptor)testEngineParameterTestDescriptor);
        List testExecutionResultList = testEngineParameterTestDescriptor.getTestExecutionResultList();
        testExecutionResultList.clear();
        Class<?> testClass = testEngineParameterTestDescriptor.getTestClass();
        String testClassName = testClass.getName();
        Object testInstance = testEngineExecutionContext.getTestInstance();
        Parameter testParameter = testEngineParameterTestDescriptor.getTestParameter();
        try {
            LOGGER.trace("injecting [%s] @TestEngine.Parameter fields ...", (Object)testClassName);
            List<Field> testParameterFields = TestEngineReflectionUtils.getParameterFields(testClass);
            for (Field field : testParameterFields) {
                LOGGER.trace("injecting [%s] @TestEngine.Parameter field [%s] ...", testClassName, field.getName());
                field.set(testInstance, testParameter);
            }
            LOGGER.trace("invoking [%s] @TestEngine.Parameter methods ...", (Object)testClassName);
            testParameterMethods = TestEngineReflectionUtils.getParameterMethods(testClass);
            Iterator iterator = testParameterMethods.iterator();
            while (iterator.hasNext()) {
                Method testParameterMethod = (Method)iterator.next();
                LOGGER.trace("invoking [%s] @TestEngine.Parameter method [%s] ...", testClassName, testParameterMethod.getName());
                testParameterMethod.invoke(testInstance, testParameter);
            }
            LOGGER.trace("invoking [%s] @TestEngine.BeforeAll methods ...", (Object)testClassName);
            for (Method beforeAllMethod : TestEngineReflectionUtils.getBeforeAllMethods(testClass)) {
                LOGGER.trace("invoking [%s] @TestEngine.BeforeAll method [%s] ...", testClassName, beforeAllMethod.getName());
                beforeAllMethod.invoke(testInstance, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t) {
            t = TestEngineExecutor.resolve(t);
            TestEngineExecutor.printStackTrace(t, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t));
        }
        finally {
            TestEngineExecutor.flush();
        }
        if (testExecutionResultList.isEmpty()) {
            children = testEngineParameterTestDescriptor.getChildren();
            testParameterMethods = children.iterator();
            while (testParameterMethods.hasNext()) {
                TestDescriptor testDescriptor = (TestDescriptor)testParameterMethods.next();
                if (!(testDescriptor instanceof MethodTestDescriptor)) continue;
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                this.execute(methodTestDescriptor, testEngineExecutionContext);
                testExecutionResultList.addAll(methodTestDescriptor.getTestExecutionResultList());
            }
        } else {
            children = testEngineParameterTestDescriptor.getChildren();
            testParameterMethods = children.iterator();
            while (testParameterMethods.hasNext()) {
                TestDescriptor testDescriptor = (TestDescriptor)testParameterMethods.next();
                if (!(testDescriptor instanceof MethodTestDescriptor)) continue;
                testEngineExecutionContext.getEngineExecutionListener().executionSkipped(testDescriptor, "@TestEngine.BeforeAll method exception");
            }
        }
        try {
            LOGGER.trace("invoking [%s] @TestEngine.AfterAll methods ...", (Object)testClassName);
            for (Method afterAllMethod : TestEngineReflectionUtils.getAfterAllMethods(testClass)) {
                LOGGER.trace("invoking [%s] @TestEngine.AfterAll method [%s] ...", testClassName, afterAllMethod.getName());
                afterAllMethod.invoke(testInstance, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t) {
            t = TestEngineExecutor.resolve(t);
            TestEngineExecutor.printStackTrace(t, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t));
        }
        finally {
            TestEngineExecutor.flush();
        }
        if (testExecutionResultList.isEmpty()) {
            testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineParameterTestDescriptor, TestExecutionResult.successful());
        } else {
            testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)testEngineParameterTestDescriptor, (TestExecutionResult)testExecutionResultList.get(0));
        }
        testEngineExecutionContext.getTestExecutionResultList().addAll(testExecutionResultList);
        TestEngineExecutor.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(MethodTestDescriptor methodTestDescriptor, TestEngineExecutionContext testEngineExecutionContext) {
        Object t2;
        LOGGER.trace("execute(TestEngineTestMethodTestDescriptor, TestEngineExecutionContext)");
        testEngineExecutionContext.getEngineExecutionListener().executionStarted((TestDescriptor)methodTestDescriptor);
        List testExecutionResultList = methodTestDescriptor.getTestExecutionResultList();
        testExecutionResultList.clear();
        Class<?> testClass = methodTestDescriptor.getTestClass();
        String testClassName = testClass.getName();
        Object testInstance = testEngineExecutionContext.getTestInstance();
        try {
            LOGGER.trace("invoking [%s] @TestEngine.BeforeEach methods ...", (Object)testClassName);
            for (Method beforeEachMethod : TestEngineReflectionUtils.getBeforeEachMethods(testClass)) {
                LOGGER.trace("invoking [%s] @TestEngine.BeforeEach method [%s] ...", testClassName, beforeEachMethod.getName());
                beforeEachMethod.invoke(testInstance, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t2) {
            t2 = TestEngineExecutor.resolve(t2);
            TestEngineExecutor.printStackTrace((Throwable)t2, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t2));
        }
        finally {
            TestEngineExecutor.flush();
        }
        try {
            Method testMethod = methodTestDescriptor.getTestMethod();
            LOGGER.trace("invoking [%s] @TestEngine.Test method [%s] ...", testClassName, testMethod.getName());
            testMethod.invoke(testInstance, (Object[])null);
            TestEngineExecutor.flush();
        }
        catch (Throwable t3) {
            t2 = TestEngineExecutor.resolve(t3);
            TestEngineExecutor.printStackTrace((Throwable)t2, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t2));
        }
        finally {
            TestEngineExecutor.flush();
        }
        try {
            LOGGER.trace("invoking [%s] @TestEngine.AfterEach methods ...", (Object)testClassName);
            for (Method afterEachMethod : TestEngineReflectionUtils.getAfterEachMethods(testClass)) {
                LOGGER.trace("invoking [%s] @TestEngine.AfterEach method [%s] ...", testClassName, afterEachMethod.getName());
                afterEachMethod.invoke(testInstance, (Object[])null);
                TestEngineExecutor.flush();
            }
        }
        catch (Throwable t4) {
            t4 = TestEngineExecutor.resolve(t4);
            TestEngineExecutor.printStackTrace(t4, System.err);
            testExecutionResultList.add(TestExecutionResult.failed((Throwable)t4));
        }
        finally {
            TestEngineExecutor.flush();
        }
        if (testExecutionResultList.isEmpty()) {
            testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)methodTestDescriptor, TestExecutionResult.successful());
        } else {
            testEngineExecutionContext.getEngineExecutionListener().executionFinished((TestDescriptor)methodTestDescriptor, (TestExecutionResult)testExecutionResultList.get(0));
        }
        testEngineExecutionContext.getTestExecutionResultList().addAll(testExecutionResultList);
        TestEngineExecutor.flush();
    }

    private void printTestHierarchy(TestDescriptor testDescriptor, int indent) {
        if (indent == 0) {
            LOGGER.trace("Test class hierarchy ...");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            stringBuilder.append(" ");
        }
        Switch.switchType(testDescriptor, Switch.switchCase(MethodTestDescriptor.class, testMethodTestDescriptor -> stringBuilder.append("method -> ").append(testMethodTestDescriptor.getTestMethod().getName()).append("()")), Switch.switchCase(ParameterTestDescriptor.class, testEngineParameterTestDescriptor -> stringBuilder.append("parameter -> ").append(testEngineParameterTestDescriptor.getTestParameter())), Switch.switchCase(ClassTestDescriptor.class, testClassTestDescriptor -> stringBuilder.append("class -> ").append(testClassTestDescriptor.getTestClass().getName())), Switch.switchCase(EngineDescriptor.class, engineDescriptor -> stringBuilder.append("engine -> ").append(engineDescriptor.getDisplayName())));
        LOGGER.trace(stringBuilder.toString());
        if (LOGGER.isTraceEnabled()) {
            for (TestDescriptor child : testDescriptor.getChildren()) {
                this.printTestHierarchy(child, indent + 2);
            }
        }
    }

    private static Throwable resolve(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return t.getCause();
        }
        return t;
    }

    public static void printStackTrace(Throwable t, PrintStream printStream) {
        printStream.println(t.getClass().getName() + ": " + t.getMessage());
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        if (stackTraceElements != null) {
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                if (stackTraceElement.getClassName().startsWith("org.antublue.test.engine")) break;
                printStream.println("    at " + stackTraceElement);
            }
        }
    }

    private static void flush() {
        System.err.flush();
        System.out.flush();
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private int threadId = 1;

        private NamedThreadFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Thread newThread(Runnable r) {
            String threadName;
            NamedThreadFactory namedThreadFactory = this;
            synchronized (namedThreadFactory) {
                threadName = String.format("test-engine-%02d", this.threadId);
                ++this.threadId;
            }
            Thread thread = new Thread(r);
            thread.setName(threadName);
            thread.setDaemon(true);
            return thread;
        }
    }
}

