/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Predicate;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestDescriptorFactory;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class MethodSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodSelectorResolver.class);
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !TestEngineReflectionUtils.getTestMethods(clazz).isEmpty();
    };

    public void resolve(MethodSelector methodSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)methodSelector.getJavaMethod().getName());
        UniqueId uniqueId = engineDescriptor.getUniqueId();
        Class clazz = methodSelector.getJavaClass();
        Method method = methodSelector.getJavaMethod();
        uniqueId = uniqueId.append("class", clazz.getName());
        ClassTestDescriptor testEngineClassTestDescriptor = TestDescriptorFactory.createClassTestDescriptor(uniqueId, clazz);
        List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.get(i);
            uniqueId = uniqueId.append("parameter", String.valueOf(i));
            ParameterTestDescriptor testEngineParameterTestDescriptor = TestDescriptorFactory.createParameterTestDescriptor(uniqueId, clazz, parameter);
            uniqueId = uniqueId.append("method", method.getName());
            MethodTestDescriptor methodTestDescriptor = TestDescriptorFactory.createMethodTestDescriptor(uniqueId, clazz, parameter, method);
            uniqueId = uniqueId.removeLastSegment();
            testEngineParameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
            uniqueId = uniqueId.removeLastSegment();
            testEngineClassTestDescriptor.addChild((TestDescriptor)testEngineParameterTestDescriptor);
        }
        engineDescriptor.addChild((TestDescriptor)testEngineClassTestDescriptor);
    }
}

