/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ParameterTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestDescriptorFactory;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class PackageSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageSelectorResolver.class);
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !TestEngineReflectionUtils.getTestMethods(clazz).isEmpty();
    };

    public void resolve(PackageSelector packageSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)packageSelector.getPackageName());
        UniqueId uniqueId = engineDescriptor.getUniqueId();
        String packageName = packageSelector.getPackageName();
        ArrayList<Class> classes = new ArrayList<Class>(ReflectionSupport.findAllClassesInPackage((String)packageName, IS_TEST_CLASS, name -> true));
        classes.sort(Comparator.comparing(Class::getName));
        for (Class clazz : classes) {
            LOGGER.trace("  class [%s]", (Object)clazz.getName());
            uniqueId = uniqueId.append("class", clazz.getName());
            ClassTestDescriptor testEngineClassTestDescriptor = TestDescriptorFactory.createClassTestDescriptor(uniqueId, clazz);
            engineDescriptor.addChild((TestDescriptor)testEngineClassTestDescriptor);
            List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
            for (int i = 0; i < parameters.size(); ++i) {
                Parameter parameter = parameters.get(i);
                uniqueId = uniqueId.append("parameter", String.valueOf(i));
                ParameterTestDescriptor testEngineParameterTestDescriptor = TestDescriptorFactory.createParameterTestDescriptor(uniqueId, clazz, parameter);
                testEngineClassTestDescriptor.addChild((TestDescriptor)testEngineParameterTestDescriptor);
                List<Method> methods = TestEngineReflectionUtils.getTestMethods(clazz);
                for (Method method : methods) {
                    uniqueId = uniqueId.append("method", method.getName());
                    MethodTestDescriptor methodTestDescriptor = TestDescriptorFactory.createMethodTestDescriptor(uniqueId, clazz, parameter, method);
                    testEngineParameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                    uniqueId = uniqueId.removeLastSegment();
                }
                testEngineParameterTestDescriptor.prune();
                uniqueId = uniqueId.removeLastSegment();
            }
            testEngineClassTestDescriptor.prune();
            uniqueId = uniqueId.removeLastSegment();
        }
    }
}

