/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class HumanReadableTime {
    private HumanReadableTime() {
    }

    public static String toHumanReadable(long duration, boolean useShortFormat) {
        long durationPositive = duration > 0L ? duration : -duration;
        long hours = TimeUnit.MILLISECONDS.toHours(durationPositive);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(durationPositive) - hours * 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(durationPositive) - hours * 60L * 60L + minutes * 60L;
        long milliseconds = durationPositive - hours * 60L * 60L * 1000L + minutes * 60L * 1000L + seconds * 1000L;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hours);
        if (useShortFormat) {
            stringBuilder.append(" h");
        } else {
            stringBuilder.append(" hour");
            if (hours != 1L) {
                stringBuilder.append("s");
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(minutes);
        if (useShortFormat) {
            stringBuilder.append(" m");
        } else {
            stringBuilder.append(" minute");
            if (minutes != 1L) {
                stringBuilder.append("s");
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(seconds);
        if (useShortFormat) {
            stringBuilder.append(" s");
        } else {
            stringBuilder.append(" second");
            if (seconds != 1L) {
                stringBuilder.append("s");
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(milliseconds);
        stringBuilder.append(" ms");
        String result = stringBuilder.toString();
        if (result.startsWith("0 h, ")) {
            result = result.substring("0 h, ".length());
        }
        if (result.startsWith("0 hours, ")) {
            result = result.substring("0 hours, ".length());
        }
        if (result.startsWith("0 m, ")) {
            result = result.substring("0 m, ".length());
        }
        if (result.startsWith("0 minutes, ")) {
            result = result.substring("0 minutes, ".length());
        }
        if (result.startsWith("0 s, ")) {
            result = result.substring("0 s, ".length());
        }
        if (result.startsWith("0 seconds, ")) {
            result = result.substring("0 seconds, ".length());
        }
        return result;
    }

    public static String now() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ENGLISH);
        return simpleDateFormat.format(new Date());
    }
}

