/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.util.Optional;
import org.antublue.test.engine.internal.TestEngineConfigurationParameters;
import org.antublue.test.engine.internal.TestEngineEngineDiscoveryRequest;
import org.antublue.test.engine.internal.TestEngineExecutor;
import org.antublue.test.engine.internal.TestEngineInformation;
import org.antublue.test.engine.internal.TestEngineTestDescriptorStore;
import org.antublue.test.engine.internal.descriptor.RunnableEngineDescriptor;
import org.antublue.test.engine.internal.discovery.TestEngineDiscoveryRequestResolver;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

public class TestEngine
implements org.junit.platform.engine.TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngine.class);
    public static final String ENGINE_ID = "antublue-test-engine";
    public static final String GROUP_ID = "org.antublue";
    public static final String ARTIFACT_ID = "test-engine";
    public static final String VERSION = TestEngineInformation.getVersion();

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        LOGGER.trace("discover(EngineDiscoveryRequest, UniqueId)");
        TestEngineEngineDiscoveryRequest testEngineDiscoveryRequest = new TestEngineEngineDiscoveryRequest(engineDiscoveryRequest, TestEngineConfigurationParameters.getInstance());
        RunnableEngineDescriptor runnableEngineDescriptor = new RunnableEngineDescriptor(UniqueId.forEngine((String)this.getId()), this.getId());
        new TestEngineDiscoveryRequestResolver().resolve(testEngineDiscoveryRequest, runnableEngineDescriptor);
        TestEngineTestDescriptorStore.getInstance().put(runnableEngineDescriptor);
        return runnableEngineDescriptor;
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute(ExecutionRequest)");
        new TestEngineExecutor().execute(executionRequest);
    }
}

