/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineConfigurationParameters;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestExecutionContext;
import org.antublue.test.engine.internal.descriptor.RunnableClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableEngineDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;

public class TestEngineExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineExecutor.class);
    private final ExecutorService executorService;

    public TestEngineExecutor() {
        int threadCount = TestEngineConfigurationParameters.getInstance().get("antublue.test.engine.thread.count").map(value -> {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue >= 1) {
                    return intValue;
                }
                throw new TestEngineException(String.format("Invalid thread count [%d]", intValue));
            }
            catch (NumberFormatException e) {
                throw new TestEngineException(String.format("Invalid thread count [%s]", value), e);
            }
        }).orElse(Runtime.getRuntime().availableProcessors());
        LOGGER.trace("thread count [%d]", (Object)threadCount);
        this.executorService = Executors.newFixedThreadPool(threadCount, new NamedThreadFactory());
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute(ExecutionRequest)");
        RunnableEngineDescriptor runnableEngineDescriptor = (RunnableEngineDescriptor)executionRequest.getRootTestDescriptor();
        TestDescriptorUtils.log((TestDescriptor)runnableEngineDescriptor);
        List<RunnableClassTestDescriptor> executableClassTestDescriptors = runnableEngineDescriptor.getChildren(RunnableClassTestDescriptor.class);
        CountDownLatch countDownLatch = new CountDownLatch(executableClassTestDescriptors.size());
        executableClassTestDescriptors.forEach(runnableClassTestDescriptor -> {
            runnableClassTestDescriptor.setTestExecutionContext(new TestExecutionContext(executionRequest, countDownLatch));
            this.executorService.submit((Runnable)runnableClassTestDescriptor);
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new TestEngineException("Test execution interrupted");
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private int threadId = 1;

        private NamedThreadFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Thread newThread(Runnable r) {
            String threadName;
            NamedThreadFactory namedThreadFactory = this;
            synchronized (namedThreadFactory) {
                threadName = String.format("test-engine-%02d", this.threadId);
                ++this.threadId;
            }
            Thread thread = new Thread(r);
            thread.setName(threadName);
            thread.setDaemon(true);
            return thread;
        }
    }
}

