/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.Optional;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.TestExecutionContext;
import org.antublue.test.engine.internal.descriptor.AbstractRunnableTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ThrowableCollector;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class RunnableMethodTestDescriptor
extends AbstractRunnableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnableMethodTestDescriptor.class);
    private final Class<?> testClass;
    private final Parameter testParameter;
    private final Method testMethod;

    public RunnableMethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Parameter testParameter, Method testMethod) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testParameter = testParameter;
        this.testMethod = testMethod;
        this.testMethod.setAccessible(true);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TestExecutionContext testExecutionContext = this.getTestExecutionContext();
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        EngineExecutionListener engineExecutionListener = testExecutionContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        Object testInstance = testExecutionContext.getTestInstance();
        Class<?> testClass = testInstance.getClass();
        String testClassName = testClass.getName();
        try {
            LOGGER.trace("invoking [%s] @TestEngine.BeforeEach methods ...", (Object)testClassName);
            for (Method beforeEachMethod : TestEngineReflectionUtils.getBeforeEachMethods(testClass)) {
                LOGGER.trace("invoking [%s] @TestEngine.BeforeEach method [%s] ...", testClassName, beforeEachMethod.getName());
                try {
                    beforeEachMethod.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            }
        }
        catch (Throwable t) {
            throwableCollector.add(t);
            RunnableMethodTestDescriptor.resolve(t).printStackTrace();
        }
        if (throwableCollector.isEmpty()) {
            try {
                LOGGER.trace("invoking [%s] @TestEngine.Test method [%s] ...", testClassName, this.testMethod.getName());
                try {
                    this.testMethod.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            }
            catch (Throwable t) {
                throwableCollector.add(t);
                RunnableMethodTestDescriptor.resolve(t).printStackTrace();
            }
        }
        try {
            LOGGER.trace("invoking [%s] @TestEngine.AfterEach methods ...", (Object)testClassName);
            for (Method afterEachMethod : TestEngineReflectionUtils.getAfterEachMethods(testClass)) {
                LOGGER.trace("invoking [%s] @TestEngine.AfterEach method [%s] ...", testClassName, afterEachMethod.getName());
                try {
                    afterEachMethod.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            }
        }
        catch (Throwable t) {
            throwableCollector.add(t);
            RunnableMethodTestDescriptor.resolve(t).printStackTrace();
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().get()));
        }
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public Parameter getTestParameter() {
        return this.testParameter;
    }
}

