/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.TestExecutionContext;
import org.antublue.test.engine.internal.descriptor.AbstractRunnableTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableMethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ThrowableCollector;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class RunnableParameterTestDescriptor
extends AbstractRunnableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnableParameterTestDescriptor.class);
    private final Class<?> testClass;
    private final Parameter testParameter;

    public RunnableParameterTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Parameter testParameter) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testParameter = testParameter;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)TestEngineReflectionUtils.getParameterSupplierMethod(this.testClass)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TestExecutionContext testExecutionContext = this.getTestExecutionContext();
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        EngineExecutionListener engineExecutionListener = testExecutionContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        Object testInstance = null;
        Class<?> testClass = null;
        String testClassName = null;
        try {
            testInstance = testExecutionContext.getTestInstance();
            testClass = testInstance.getClass();
            testClassName = testClass.getName();
            testExecutionContext.setTestInstance(testInstance);
            List<Field> testParameterFields = TestEngineReflectionUtils.getParameterFields(testClass);
            for (Field field : testParameterFields) {
                LOGGER.trace("injecting [%s] @TestEngine.Parameter field [%s] ...", testClassName, field.getName());
                try {
                    field.set(testInstance, this.testParameter);
                }
                finally {
                    this.flush();
                }
            }
            LOGGER.trace("invoking [%s] @TestEngine.Parameter methods ...", (Object)testClassName);
            List<Method> testParameterMethods = TestEngineReflectionUtils.getParameterMethods(testClass);
            for (Method testParameterMethod : testParameterMethods) {
                LOGGER.trace("invoking [%s] @TestEngine.Parameter method [%s] ...", testClassName, testParameterMethod.getName());
                try {
                    testParameterMethod.invoke(testInstance, this.testParameter);
                }
                finally {
                    this.flush();
                }
            }
        }
        catch (Throwable t) {
            throwableCollector.add(t);
            RunnableParameterTestDescriptor.resolve(t).printStackTrace();
        }
        if (throwableCollector.isEmpty()) {
            try {
                List<Method> beforeAllMethods = TestEngineReflectionUtils.getBeforeAllMethods(testClass);
                for (Method method : beforeAllMethods) {
                    LOGGER.trace("invoking [%s] @TestEngine.BeforeAll method [%s] ...", testClassName, method.getName());
                    try {
                        method.invoke(testInstance, (Object[])null);
                    }
                    finally {
                        this.flush();
                    }
                }
                this.getChildren(RunnableMethodTestDescriptor.class).forEach(executableMethodTestDescriptor -> {
                    executableMethodTestDescriptor.setTestExecutionContext(testExecutionContext);
                    executableMethodTestDescriptor.run();
                    throwableCollector.addAll(executableMethodTestDescriptor.getThrowableCollector());
                });
            }
            catch (Throwable t) {
                throwableCollector.add(t);
                RunnableParameterTestDescriptor.resolve(t).printStackTrace();
            }
        }
        try {
            List<Method> afterAllMethods = TestEngineReflectionUtils.getAfterAllMethods(testClass);
            for (Method method : afterAllMethods) {
                LOGGER.trace("invoking [%s] @TestEngine.AfterAll method [%s] ...", testClassName, method.getName());
                try {
                    method.invoke(testInstance, (Object[])null);
                }
                finally {
                    this.flush();
                }
            }
        }
        catch (Throwable t) {
            throwableCollector.add(t);
            RunnableParameterTestDescriptor.resolve(t).printStackTrace();
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().get()));
        }
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Parameter getTestParameter() {
        return this.testParameter;
    }
}

