/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery.resolver;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestDescriptorUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.RunnableClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableMethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class ClasspathRootResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathRootResolver.class);
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class)) {
            return false;
        }
        return !Modifier.isAbstract(clazz.getModifiers()) && !TestEngineReflectionUtils.getTestMethods(clazz).isEmpty();
    };

    public void resolve(ClasspathRootSelector classpathRootSelector, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolve [%s]", (Object)classpathRootSelector);
        UniqueId uniqueId = engineDescriptor.getUniqueId();
        URI uri = classpathRootSelector.getClasspathRoot();
        LOGGER.trace("uri [%s]", (Object)uri);
        ArrayList<Class> classes = new ArrayList<Class>(ReflectionUtils.findAllClassesInClasspathRoot((URI)uri, IS_TEST_CLASS, name -> true));
        LOGGER.trace("classes.size() [%d]", (Object)classes.size());
        classes.sort(Comparator.comparing(Class::getName));
        for (Class clazz : classes) {
            LOGGER.trace("  class [%s]", (Object)clazz.getName());
            uniqueId = uniqueId.append("class", clazz.getName());
            RunnableClassTestDescriptor testEngineClassTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(uniqueId, clazz);
            engineDescriptor.addChild((TestDescriptor)testEngineClassTestDescriptor);
            List<Parameter> parameters = TestEngineReflectionUtils.getParameters(clazz);
            for (int i = 0; i < parameters.size(); ++i) {
                Parameter parameter = parameters.get(i);
                uniqueId = uniqueId.append("parameter", String.valueOf(i));
                RunnableParameterTestDescriptor testEngineParameterTestDescriptor = TestDescriptorUtils.createParameterTestDescriptor(uniqueId, clazz, parameter);
                testEngineClassTestDescriptor.addChild((TestDescriptor)testEngineParameterTestDescriptor);
                List<Method> methods = TestEngineReflectionUtils.getTestMethods(clazz);
                for (Method method : methods) {
                    uniqueId = uniqueId.append("method", method.getName());
                    RunnableMethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(uniqueId, clazz, parameter, method);
                    testEngineParameterTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                    uniqueId = uniqueId.removeLastSegment();
                }
                testEngineParameterTestDescriptor.prune();
                uniqueId = uniqueId.removeLastSegment();
            }
            testEngineClassTestDescriptor.prune();
            uniqueId = uniqueId.removeLastSegment();
        }
    }
}

