/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.RunnableClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableMethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.RunnableParameterTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Switch;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public final class TestDescriptorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDescriptorUtils.class);

    private TestDescriptorUtils() {
    }

    public static RunnableClassTestDescriptor createClassTestDescriptor(UniqueId uniqueId, Class<?> clazz) {
        return new RunnableClassTestDescriptor(uniqueId, TestEngineReflectionUtils.getDisplayName(clazz), clazz);
    }

    public static RunnableParameterTestDescriptor createParameterTestDescriptor(UniqueId uniqueId, Class<?> clazz, Parameter parameter) {
        return new RunnableParameterTestDescriptor(uniqueId, parameter.name(), clazz, parameter);
    }

    public static RunnableMethodTestDescriptor createMethodTestDescriptor(UniqueId uniqueId, Class<?> clazz, Parameter parameter, Method method) {
        return new RunnableMethodTestDescriptor(uniqueId, TestEngineReflectionUtils.getDisplayName(method), clazz, parameter, method);
    }

    public static void trace(TestDescriptor testDescriptor) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("--------------------");
            LOGGER.trace("Test descriptor tree");
            LOGGER.trace("--------------------");
            TestDescriptorUtils.trace(testDescriptor, 0);
            LOGGER.trace("------------------------");
        }
    }

    private static void trace(TestDescriptor testDescriptor, int indent) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            stringBuilder.append(" ");
        }
        Switch.switchType(testDescriptor, Switch.switchCase(RunnableMethodTestDescriptor.class, testMethodTestDescriptor -> stringBuilder.append("method -> ").append(testMethodTestDescriptor.getUniqueId()).append("()")), Switch.switchCase(RunnableParameterTestDescriptor.class, testEngineParameterTestDescriptor -> stringBuilder.append("parameter -> ").append(testEngineParameterTestDescriptor.getUniqueId())), Switch.switchCase(RunnableClassTestDescriptor.class, testClassTestDescriptor -> stringBuilder.append("class -> ").append(testClassTestDescriptor.getUniqueId())), Switch.switchCase(EngineDescriptor.class, engineDescriptor -> stringBuilder.append("engine -> ").append(engineDescriptor.getDisplayName())));
        LOGGER.trace(stringBuilder.toString());
        testDescriptor.getChildren().forEach(testDescriptor1 -> TestDescriptorUtils.trace(testDescriptor1, indent + 2));
    }
}

