/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Parameter;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public final class TestEngineReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineReflectionUtils.class);
    private static final Map<Class<?>, Method> parameterSupplierMethodCache = new HashMap();
    private static final Map<Class<?>, List<Field>> parameterFieldCache = new HashMap();
    private static final Map<Class<?>, List<Method>> parameterMethodCache = new HashMap();
    private static final Map<Class<?>, List<Method>> beforeClassMethodCache = new HashMap();
    private static final Map<Class<?>, List<Method>> beforeAllMethodCache = new HashMap();
    private static final Map<Class<?>, List<Method>> beforeEachMethodCache = new HashMap();
    private static final Map<Class<?>, List<Method>> testMethodCache = new HashMap();
    private static final Map<Class<?>, List<Method>> afterEachMethodCache = new HashMap();
    private static final Map<Class<?>, List<Method>> afterAllMethodCache = new HashMap();
    private static final Map<Class<?>, List<Method>> afterClassMethodCache = new HashMap();

    private TestEngineReflectionUtils() {
    }

    public static List<Parameter> getParameters(Class<?> clazz) {
        try {
            Method method = TestEngineReflectionUtils.getParameterSupplierMethod(clazz);
            Stream stream = (Stream)method.invoke(null, (Object[])null);
            return stream.collect(Collectors.toList());
        }
        catch (TestClassConfigurationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestClassConfigurationException(String.format("Can't get Stream<Parameter> from class [%s]", clazz.getName()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getParameterFields(Class<?> clazz) {
        Map<Class<?>, List<Field>> map = parameterFieldCache;
        synchronized (map) {
            LOGGER.trace("getParameterFields(%s)", (Object)clazz.getName());
            if (parameterFieldCache.containsKey(clazz)) {
                return parameterFieldCache.get(clazz);
            }
            List<Field> parameterFields = TestEngineReflectionUtils.getFields(clazz, TestEngine.Parameter.class, Parameter.class);
            parameterFieldCache.put(clazz, parameterFields);
            return parameterFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getBeforeClassMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = beforeClassMethodCache;
        synchronized (map) {
            LOGGER.trace("getBeforeClassMethods(%s)", (Object)clazz.getName());
            if (beforeClassMethodCache.containsKey(clazz)) {
                return beforeClassMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.BeforeClass.class, Scope.STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methods);
            methods = Collections.unmodifiableList(methods);
            beforeClassMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getParameterMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = parameterMethodCache;
        synchronized (map) {
            LOGGER.trace("getParameterMethods(%s)", (Object)clazz.getName());
            if (parameterMethodCache.containsKey(clazz)) {
                return parameterMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.Parameter.class, Scope.NON_STATIC, Void.class, Parameter.class);
            TestEngineReflectionUtils.sortByOrderAnnotation(methods);
            methods = Collections.unmodifiableList(methods);
            parameterMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getBeforeAllMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = beforeAllMethodCache;
        synchronized (map) {
            if (beforeAllMethodCache.containsKey(clazz)) {
                return beforeAllMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.BeforeAll.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methods);
            methods = Collections.unmodifiableList(methods);
            beforeAllMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getBeforeEachMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = beforeEachMethodCache;
        synchronized (map) {
            if (beforeEachMethodCache.containsKey(clazz)) {
                return beforeEachMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.BeforeEach.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methods);
            methods = Collections.unmodifiableList(methods);
            beforeEachMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getTestMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = testMethodCache;
        synchronized (map) {
            LOGGER.trace("getTestMethods(%s)", (Object)clazz.getName());
            if (testMethodCache.containsKey(clazz)) {
                return testMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.Test.class, Scope.NON_STATIC, Void.class, null).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            TestEngineReflectionUtils.sortByOrderAnnotation(methods);
            methods = Collections.unmodifiableList(methods);
            testMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getAfterEachMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = afterEachMethodCache;
        synchronized (map) {
            if (afterEachMethodCache.containsKey(clazz)) {
                return afterEachMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.AfterEach.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methods);
            methods = Collections.unmodifiableList(methods);
            afterEachMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getAfterAllMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = afterAllMethodCache;
        synchronized (map) {
            if (afterAllMethodCache.containsKey(clazz)) {
                return afterAllMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.AfterAll.class, Scope.NON_STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methods);
            methods = Collections.unmodifiableList(methods);
            afterAllMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getAfterClassMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = afterClassMethodCache;
        synchronized (map) {
            if (afterClassMethodCache.containsKey(clazz)) {
                return afterClassMethodCache.get(clazz);
            }
            List<Method> methods = TestEngineReflectionUtils.getMethods(clazz, TestEngine.AfterClass.class, Scope.STATIC, Void.class, null);
            TestEngineReflectionUtils.sortByOrderAnnotation(methods);
            methods = Collections.unmodifiableList(methods);
            afterClassMethodCache.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getParameterSupplierMethod(Class<?> clazz) {
        Map<Class<?>, Method> map = parameterSupplierMethodCache;
        synchronized (map) {
            LOGGER.trace("getParameterSupplierMethod(%s)", (Object)clazz.getName());
            if (parameterSupplierMethodCache.containsKey(clazz)) {
                return parameterSupplierMethodCache.get(clazz);
            }
            List<Method> methodList = TestEngineReflectionUtils.getMethods(clazz, TestEngine.ParameterSupplier.class, Scope.STATIC, Stream.class, null);
            if (methodList.size() != 1) {
                throw new TestClassConfigurationException(String.format("Class [%s] must define one @TestEngine.ParameterSupplier method", clazz.getName()));
            }
            Method method = methodList.get(0);
            parameterSupplierMethodCache.put(clazz, method);
            return method;
        }
    }

    public static String getDisplayName(Method method) {
        String value;
        String displayName = method.getName();
        if (method.isAnnotationPresent(TestEngine.DisplayName.class) && (value = method.getAnnotation(TestEngine.DisplayName.class).value()) != null && !value.trim().isEmpty()) {
            displayName = value.trim();
        }
        return displayName;
    }

    public static String getDisplayName(Class<?> clazz) {
        String value;
        String displayName = clazz.getName();
        if (clazz.isAnnotationPresent(TestEngine.DisplayName.class) && (value = clazz.getAnnotation(TestEngine.DisplayName.class).value()) != null && !value.trim().isEmpty()) {
            displayName = value.trim();
        }
        return displayName;
    }

    private static List<Field> getFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType) {
        LOGGER.trace("getFields(%s, %s, %s)", clazz.getName(), annotation.getName(), fieldType.getName());
        LinkedHashSet<Field> fieldSet = new LinkedHashSet<Field>();
        TestEngineReflectionUtils.resolveFields(clazz, annotation, fieldType, fieldSet);
        ArrayList<Field> fields = new ArrayList<Field>(fieldSet);
        fields.sort(Comparator.comparing(Field::getName));
        return fields;
    }

    private static void resolveFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType, Set<Field> fieldSet) {
        LOGGER.trace("resolveFields(%s, %s, %s)", clazz.getName(), annotation.getName(), fieldType);
        Stream.of(clazz.getDeclaredFields()).filter(field -> {
            int modifiers = field.getModifiers();
            return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && field.isAnnotationPresent(annotation) && field.getType() == fieldType;
        }).forEach(field -> {
            field.setAccessible(true);
            fieldSet.add((Field)field);
        });
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            TestEngineReflectionUtils.resolveFields(declaringClass, annotation, fieldType, fieldSet);
        }
    }

    private static List<Method> getMethods(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("getMethods(%s, %s, %s, %s", new Object[]{clazz.getName(), annotation.getName(), scope, returnType.getName()}));
        if (parameterTypes != null) {
            for (Class<?> parameterTypeClass : parameterTypes) {
                stringBuilder.append(", ").append(parameterTypeClass.getName());
            }
        }
        stringBuilder.append(")");
        LOGGER.trace(stringBuilder.toString());
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        TestEngineReflectionUtils.resolveMethods(clazz, annotation, scope, returnType, parameterTypes, methodMap);
        ArrayList<Method> methodList = new ArrayList<Method>(methodMap.values());
        methodList.sort(Comparator.comparing(Method::getName));
        return methodList;
    }

    private static void resolveMethods(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?>[] parameterTypes, Map<String, Method> methodMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("resolveMethods(%s, %s, %s, %s", new Object[]{clazz.getName(), annotation.getName(), scope, returnType.getName()}));
        if (parameterTypes != null) {
            for (Class<?> parameterTypeClass : parameterTypes) {
                stringBuilder.append(", ").append(parameterTypeClass.getName());
            }
        }
        stringBuilder.append(")");
        LOGGER.trace(stringBuilder.toString());
        Stream.of(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotation)).filter(method -> {
            int modifiers = method.getModifiers();
            return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
        }).filter(method -> {
            int modifiers = method.getModifiers();
            if (scope == Scope.STATIC && !Modifier.isStatic(modifiers)) {
                throw new TestClassConfigurationException(String.format("%s method [%s] must be declared static", TestEngineReflectionUtils.getAnnotationDisplayName(annotation), method.getName()));
            }
            if (scope != Scope.STATIC && Modifier.isStatic(modifiers)) {
                throw new TestClassConfigurationException(String.format("%s method [%s] must be not be declared static", TestEngineReflectionUtils.getAnnotationDisplayName(annotation), method.getName()));
            }
            return true;
        }).filter(method -> {
            if (parameterTypes == null) {
                return method.getParameterTypes().length == 0;
            }
            if (parameterTypes.length != method.getParameterCount()) {
                return false;
            }
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (methodParameterTypes[i].isAssignableFrom(parameterTypes[i])) continue;
                return false;
            }
            return true;
        }).filter(method -> {
            if (returnType == Void.class) {
                return method.getReturnType().getName().equals("void");
            }
            return method.getReturnType().equals(returnType);
        }).forEach(method -> {
            if (methodMap.putIfAbsent(method.getName(), (Method)method) == null) {
                method.setAccessible(true);
            }
        });
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            TestEngineReflectionUtils.resolveMethods(declaringClass, annotation, scope, returnType, parameterTypes, methodMap);
        }
    }

    private static void sortByOrderAnnotation(List<Method> methods) {
        methods.sort((o1, o2) -> {
            boolean o1AnnotationPresent = o1.isAnnotationPresent(TestEngine.Order.class);
            boolean o2AnnotationPresent = o2.isAnnotationPresent(TestEngine.Order.class);
            if (o1AnnotationPresent) {
                if (o2AnnotationPresent) {
                    int o1Order = o1.getAnnotation(TestEngine.Order.class).value();
                    int o2Order = o2.getAnnotation(TestEngine.Order.class).value();
                    return Integer.compare(o1Order, o2Order);
                }
                return -1;
            }
            if (o2AnnotationPresent) {
                return 1;
            }
            String o1DisplayName = TestEngineReflectionUtils.getDisplayName(o1);
            String o2DisplayName = TestEngineReflectionUtils.getDisplayName(o2);
            return o1DisplayName.compareTo(o2DisplayName);
        });
    }

    private static String getAnnotationDisplayName(Class<? extends Annotation> annotation) {
        return String.format("@%s.%s", annotation.getDeclaringClass().getSimpleName(), annotation.getSimpleName());
    }

    private static enum Scope {
        STATIC,
        NON_STATIC;

    }
}

