/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.antublue.test.engine.internal.TestExecutionContext;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

abstract class AbstractRunnableTestDescriptor
extends AbstractTestDescriptor
implements Runnable {
    private final ThrowableCollector throwableCollector = new ThrowableCollector();
    private TestExecutionContext testExecutionContext;

    protected AbstractRunnableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public <T> List<T> getChildren(Class<T> clazz) {
        return this.getChildren().stream().map(testDescriptor -> testDescriptor).collect(Collectors.toList());
    }

    public void setTestExecutionContext(TestExecutionContext testExecutionContext) {
        this.testExecutionContext = testExecutionContext;
    }

    protected TestExecutionContext getTestExecutionContext() {
        return this.testExecutionContext;
    }

    protected ThrowableCollector getThrowableCollector() {
        return this.throwableCollector;
    }

    @Override
    public abstract void run();

    protected static Throwable resolve(Throwable t) {
        if (t instanceof RuntimeException) {
            t = t.getCause();
        }
        if (t instanceof InvocationTargetException) {
            return t.getCause();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            PrintStream printStream2 = System.err;
            synchronized (printStream2) {
                System.out.flush();
                System.err.flush();
            }
        }
    }
}

